# List of Drugs Menu
run<-function()
{
 cat("\n")
  file.menu <- c("Aminoglycosides                        ",
                 "Anti-HIV drugs",
                 "Carbamazepine",
                 "Digoxin",
                 "Enoxaparin",
                 "Imatinib mesylate",
                 "Immunosuppressants",
                 "Lithium",
                 "Phenytoin",
                 "Theophylline",
                 "Valproate",
                 "Vancomycin",              
                 "Warfarin (PK/PD)",
                 "Quit")
  pick <- menu(file.menu, title = "<< Drug List (TDM) >>")
  if (pick == 1){
     cat("\n\n")
     Ami.model()
  } else {
    if (pick == 2){
      cat("\n\n") 
      AntiHIV.menu()
    } else {
    if (pick == 3){
      cat("\n\n") 
      Car.model()
    }  else {
    if (pick == 4){
      cat("\n\n") 
      Dig.menu()
    } else {
    if (pick == 5){
      cat("\n\n") 
      Eno.model()      
    } else {
    if (pick == 6){
      cat("\n\n") 
      Ima.model()     
    } else {
    if (pick == 7){
      cat("\n\n") 
      Immunosuppressants.menu()      
    } else {
    if (pick == 8){
      cat("\n\n") 
      Lit.menu()
    } else {
    if (pick == 9){
      cat("\n\n") 
      Phe.model()
    } else {
    if (pick == 10){
      cat("\n\n") 
      Theall.menu()
    } else {
    if (pick == 11){
      cat("\n\n") 
      Val.menu()
    } else {
    if (pick == 12){
      cat("\n\n") 
      Van.model()
    } else {
      if (pick == 13){
        cat("\n\n")  
        War.model()
      } else {
      if (pick == 14){
        cat("\nBye-Bye~~ \n\n")     
      }
     }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
    }
  }
}

#Aminoglycoside data file 
Ami.model <- function()
{
  file.menu <- c("single subj with single conc",                                                     #list of Aminoglycoside data type   
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")          
  if (pick == 1){                                                                    # chosse single subject with single concentration
     cat("\n")                                                                       # show input and output information make user convenience to use 
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Ht = height(cm)                                      \n")
     cat("    Scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    tin = infusion time(hr)                              \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    c = measured steady-state conc.(mg/L)                \n") 
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")       # tell user how to edit table of Aminoglycoside input data information
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmiSSpar<-data.frame(parameter=c("Gender","age (yr)","bw (kg)","Ht (cm)","Scr (mg/dL)","D (mg)","tau (hr)","tin (hr)","ts (hr)","c (mg/L)"),value=c(0))      # edit table of Aminoglycoside input data information     
     AmiSSpar<-edit(AmiSSpar)                                                                                                                                     # show table of Aminoglycoside input data information for user editing
     AmiSSpar<-ycheck(AmiSSpar)                                                                                                                                   # avoid user missing input information
     cat("\n")                                                                                                                                                    # Ť@
     Ami.ss(AmiSSpar[10,2],AmiSSpar[7,2],AmiSSpar[9,2],AmiSSpar[8,2],AmiSSpar[6,2],AmiSSpar[3,2],AmiSSpar[4,2],AmiSSpar[5,2],AmiSSpar[1,2],AmiSSpar[2,2])   # calculate individual Aminoglycoside PK parameters and show its prediction
     get(getOption("device"))()                                              # open a new window
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)                           # show plots of history
     get(getOption("device"))()                                              
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)                       # show plots of density
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)                       # show pots of autocorrection
     cat("\n\n")          
     cat("**********************************************************\n")     # show Aminoglycoside output data information
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                                  \n")
     cat("    V = volume of distribution (L)                        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))                                                 # show predicted PK parameters of Aminoglycoside
     cat("\n") 
     C<-infcpr(AmiSSpar[6,2],AmiSSpar[8,2],AmiSSpar[7,2],AmiSSpar[9,2]+AmiSSpar[8,2])     # calculate predicted steady-state measured concentration of Aminoglycoside (equation of intermediate iv infusion concentration)
     sim<-matrix(C[1 ,1])                                                                 # take the entry of form[1,1] as the input of sim
     coutput<-data.frame(sim)                                                             # RWҨXӪ[1,1]couput
     colnames(coutput)<-list("Cmss_pr (mg/L)")                                            # éRW欰Cmss_pr(mg/L)
     output1<-coutput                                                                     # NCmss_prRWcoutput1    
     show(coutput)                                                                        # show the concentration of Aminoglycoside  
     C<-infcpr(AmiSSpar[6,2],AmiSSpar[8,2],AmiSSpar[7,2],AmiSSpar[8,2])                   # calculate predicted steady-state peak concentration of Aminoglycoside
     sim<-matrix(C[1 ,1])                                                                 
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")                                            # éRW欰Cpss_pr(mg/L)
     output2<-coutput                                                                     # NCpss_prRWcoutput2
     show(coutput)
     C<-infcpr(AmiSSpar[6,2],AmiSSpar[8,2],AmiSSpar[7,2],AmiSSpar[7,2])                   # calculate predicted steady-state trough concentration of Aminoglycoside
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")                                            # éRW欰Ctss_pr(mg/L)
     output3<-coutput                                                                     # NCmss_prRWcoutput3
     show(coutput)     
     cat("\n")   
     Ami.more(AmiSSpar,output1,output2,output3)                                           # calculate dose adjustment of Aminoflycoside with single subject single concentration
  } 
   else if (pick == 2){                                                                   # chosse single subject with each multiple concentrations    
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Ht = height(cm)                                      \n")
     cat("    Scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    tin = infusion time(hr)                              \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmiSMMpar<-data.frame(parameter=c("Gender","age (yr)","bw (kg)","Ht (cm)","Scr (mg/dL)","D (mg)","tau (hr)","tin (hr)"),value=c(0))   # edit table of Aminoglycoside input data information except ts and conc 
     AmiSMMpar<-edit(AmiSMMpar)
     AmiSMMpar<-ycheck(AmiSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    Css-pr = predicted steady-state conc. (mg/L)         \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmiSMpar<-data.frame(ts=c(0),conc=c(0))                                         # edit table of Aminoglycoside input data information including ts and conc (檺e{覡We{覡P)                                                                                              
     AmiSMpar<-edit(AmiSMpar)                                                        # show table of Aminoglycoside input data information for user editing
     AmiSMpar<-mscheck(AmiSMpar)                                                     # avoid user missing input information
     cat("\n")
     Ami.sm(length(AmiSMpar$ts),AmiSMpar$conc,AmiSMpar$ts,AmiSMMpar[7,2],AmiSMMpar[8,2],AmiSMMpar[6,2],AmiSMMpar[3,2],AmiSMMpar[4,2],AmiSMMpar[5,2],AmiSMMpar[1,2],AmiSMMpar[2,2])   # calculate individual Aminoglycoside PK parameters and show its prediction
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                                  \n")
     cat("    V = volume of distribution (L)                        \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(AmiSMMpar[6,2],AmiSMMpar[8,2],AmiSMMpar[7,2],AmiSMMpar[8,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     outptu1<-coutput
     show(coutput)  
     C<-infcpr(AmiSMMpar[6,2],AmiSMMpar[8,2],AmiSMMpar[7,2],AmiSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")
     Amism.more(AmiSMMpar,AmiSMpar,output1,output2)                # calculate dose adjustment of Aminoflycoside with single subject and each multiple concentrations
  } 
     else if (pick == 3){                                                                   # chosse multiple subjects with each single concentration    
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Ht = height(cm)                                      \n")
     cat("    Scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    tin = infusion time(hr)                              \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("**********************************************************\n\n")        
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmiMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),bw=c(0),Ht=c(0),Scr=c(0),D=c(0),tau=c(0),tin=c(0),ts=c(0),c=c(0))    
     AmiMSpar<-edit(AmiMSpar)
     AmiMSpar<-ymscheck(AmiMSpar)
     cat("\n")
     Ami.ms(length(AmiMSpar$subject),AmiMSpar$c,AmiMSpar$tau,AmiMSpar$ts,AmiMSpar$tin,AmiMSpar$D,AmiMSpar$bw,AmiMSpar$Ht,AmiMSpar$Scr,AmiMSpar$Gender,AmiMSpar$age)  # calculate individual Aminoglycoside PK parameters and show its prediction
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("    --Aminoglycoside output data information--            \n")
     cat("    cl = clerance (L/hr)                                  \n")
     cat("    V = volume of distribution (L)                        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(AmiMSpar$D,AmiMSpar$tin,AmiMSpar$tau,AmiMSpar$ts+AmiMSpar$tin)  
     sim<-matrix(C[ ,1])                                                         # [,1]
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput) 
     C<-infcpr(AmiMSpar$D,AmiMSpar$tin,AmiMSpar$tau,AmiMSpar$tin)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)  
     C<-infcpr(AmiMSpar$D,AmiMSpar$tin,AmiMSpar$tau,AmiMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)                            
     cat("\n")
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Amims.pkoutput(AmiMSpar,output1,output2,output3)         
     cal.again()
  } 
     else if (pick == 4){                                                                   # chosse multiple subjects with each multiple concentrations         
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Ht = height(cm)                                      \n")
     cat("    Scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    tin = infusion time(hr)                              \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     AmiMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),bw=c(0),Ht=c(0),Scr=c(0),D=c(0),tau=c(0),tin=c(0))      # edit table of Aminoglycoside input data information except ts and conc 
     AmiMMpar<-edit(AmiMMpar)
     AmiMMpar<-ymscheck(AmiMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Aminoglycoside input data information--            \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time since infusion end (hr)           \n")
     cat("*********************************************************\n\n")
     AmiMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))                  # edit table of Aminoglycoside input data information including subject, ts and conc
     AmiMMMpar<-edit(AmiMMMpar)
     AmiMMMpar<-mscheck(AmiMMMpar)
     for(i in 1:length(unique(AmiMMpar$subject))){       # Loop, FphHhIѼ(ܭp@ӤH)
     a=length(AmiMMMpar$ts[AmiMMMpar$subject==i])        # a=number of sampling time of subject[i]
     b=AmiMMMpar$conc[AmiMMMpar$subject==i]              # b=concentration of subject[i]
     C=AmiMMMpar$ts[AmiMMMpar$subject==i]                # c=sampling time of subject[i]
     d=AmiMMpar$tau[AmiMMpar$subject==i]                 # d=dosing interval of subject[i]
     e=AmiMMpar$tin[AmiMMpar$subject==i]                 # e=infusion tiem of subject[i]
     f=AmiMMpar$D[AmiMMpar$subject==i]                   # f=dose of subject[i]  
     g=AmiMMpar$bw[AmiMMpar$subject==i]                  # g=bw of subject[i]
     h=AmiMMpar$Ht[AmiMMpar$subject==i]                  # h=ht of subject[i]
     l=AmiMMpar$Scr[AmiMMpar$subject==i]                 # l=Scr of subject[i]
     J=AmiMMpar$Gender[AmiMMpar$subject==i]              # J=Gender of subject[i]
     k=AmiMMpar$age[AmiMMpar$subject==i]                 # k=age of subject[i]
     Ami.mm(a,b,C,d,e,f,g,h,l,J,k,i)                     # calculate individual Aminoglycoside PK parameters and show its prediction
     cat("\n")
     cat("**************************************************************************\n")
     cat("                          << Subject",i,">>                           \n\n" )
     cat("    --Aminoglycoside output data information--                        \n")
     cat("   cl = clerance (L/hr)                                               \n")
     cat("   v = volume of distribution (L)                                 \n")
     cat("   Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mg/L)   \n\n")
     windows()                                           # open a new window
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(f,e,d,e)                                   
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     show(coutput) 
     C<-infcpr(AmiMMpar$D[AmiMMpar$subject==i],AmiMMpar$tin[AmiMMpar$subject==i],AmiMMpar$tau[AmiMMpar$subject==i],AmiMMpar$tau[AmiMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n**************************************************************************\n")
     }
     cal.again()         # ask user does he want to calculate another drug again?
  } 
  else if (pick == 5){   # go back to upper layer
     cat("\n\n") 
     run()
  }      
}

#Carbamazepine data file 
Car.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Yes=1;No=0)                    \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CBZSSpar<-data.frame(parameter=c("TBW (kg)","PB","VPA","PHT","E","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     CBZSSpar<-edit(CBZSSpar)
     CBZSSpar<-ycheck(CBZSSpar)
     cat("\n")
     Car.ss(CBZSSpar[9,2],CBZSSpar[7,2],CBZSSpar[8,2],CBZSSpar[6,2],CBZSSpar[1,2],CBZSSpar[2,2],CBZSSpar[3,2],CBZSSpar[4,2],CBZSSpar[5,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl = clerance/bioavailability (L/hr)                 \n")
     cat("    V = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)    \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-pocpr(1.2,CBZSSpar[6,2],CBZSSpar[7,2],CBZSSpar[8,2])               # calculate predicted steady-state measured concentration of Carbamazepine (equation of oral concentration)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-pocpr(1.2,CBZSSpar[6,2],CBZSSpar[7,2],CBZSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")   
     Car.more(CBZSSpar,output1,output2)
  }
    else if (pick == 2){
     cat("\n")
     cat("***********************************************************\n") 
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CBZSMMpar<-data.frame(parameter=c("TBW (kg)","PB","VPA","PHT","E","D (mg)","tau (hr)"),value=c(0))
     CBZSMMpar<-edit(CBZSMMpar)
     CBZSMMpar<-ycheck(CBZSMMpar)
     cat("\n")
     cat("*********************************************************\n") 
     cat("    --Carbamazepine input data information--             \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    conc = measured steady-state conc.(mg/L)             \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CBZSMpar<-data.frame(ts=c(0),conc=c(0))
     CBZSMpar<-edit(CBZSMpar)
     CBZSMpar<-mscheck(CBZSMpar)
     cat("\n")
     Car.sm(length(CBZSMpar$ts),CBZSMpar$conc,CBZSMpar$ts,CBZSMMpar[7,2],CBZSMMpar[6,2],CBZSMMpar[1,2],CBZSMMpar[2,2],CBZSMMpar[3,2],CBZSMMpar[4,2],CBZSMMpar[5,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Carbamazepine output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-pocpr(1.2,CBZSMMpar[6,2],CBZSMMpar[7,2],CBZSMMpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)     
     cat("\n")
     Carsm.more(CBZSMMpar,CBZSMpar,coutput)  
  }     
    else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("***********************************************************\n")
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("    ts = sampling time(hr)                                 \n")
     cat("    c = measured steady-state conc.(mg/L)                  \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CBZMSpar<-data.frame(subject=c(1,2),TBW=c(0),PB=c(0),VPA=c(0),PHT=c(0),E=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     CBZMSpar<-edit(CBZMSpar)
     CBZMSpar<-ymscheck(CBZMSpar)
     cat("\n")
     Car.ms(length(CBZMSpar$subject),CBZMSpar$c,CBZMSpar$tau,CBZMSpar$ts,CBZMSpar$D,CBZMSpar$TBW,CBZMSpar$PB,CBZMSpar$VPA,CBZMSpar$PHT,CBZMSpar$E)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Carbamazepine output data information--              \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-pocpr(1.2,CBZMSpar$D,CBZMSpar$tau,CBZMSpar$ts)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)  
     C<-pocpr(1.2,CBZMSpar$D,CBZMSpar$tau,CBZMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()  
     Carms.pkoutput(CBZMSpar,output1,output2)  
     cal.again()
  }     
   else if (pick == 4){
   cat("\n")
     cat("***********************************************************\n") 
     cat("    --Carbamazepine input data information--               \n")
     cat("    TBW = body weight(kg)                                  \n")
     cat("    PB = combine Phenobarbital(Y=1;N=0)                    \n")
     cat("    VPA = taking VPA and VPA daily dose >18 mg/kg(Y=1;N=0) \n")
     cat("    PHT = combine Phenytoin(Y=1;N=0)                       \n")
     cat("    E = age more than 65yr(Y=1;N=0)                        \n")
     cat("    D = dose for each dosing interval(mg)                  \n")
     cat("    tau = dosing interval(hr)                              \n")
     cat("***********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CBZMMpar<-data.frame(subject=c(1,2),TBW=c(0),PB=c(0),VPA=c(0),PHT=c(0),E=c(0),D=c(0),tau=c(0))
     CBZMMpar<-edit(CBZMMpar)
     CBZMMpar<-ymscheck(CBZMMpar)
     cat("\n")
     cat("*********************************************************\n") 
     cat("    --Carbamazepine input data information--             \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    conc = measured steady-state conc.(mg/L)             \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")    
     CBZMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     CBZMMMpar<-edit(CBZMMMpar)
     CBZMMMpar<-mscheck(CBZMMMpar)
     for(i in 1:length(unique(CBZMMpar$subject))){
     J=length(CBZMMMpar$ts[CBZMMMpar$subject==i])
     A=CBZMMMpar$conc[CBZMMMpar$subject==i]
     B=CBZMMMpar$ts[CBZMMMpar$subject==i]
     C=CBZMMpar$tau[CBZMMpar$subject==i]
     d=CBZMMpar$D[CBZMMpar$subject==i]
     e=CBZMMpar$TBW[CBZMMpar$subject==i]
     F=CBZMMpar$PB[CBZMMpar$subject==i]
     G=CBZMMpar$VPA[CBZMMpar$subject==i]
     H=CBZMMpar$PHT[CBZMMpar$subject==i]
     K=CBZMMpar$E[CBZMMpar$subject==i]
     Car.mm(J,A,B,C,d,e,F,G,H,K,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                        << Subject",i,">>                           \n\n" )
     cat("    --Carbamazepine output data information--                       \n")
     cat("     cl_F = clerance/bioavailability (L/hr)                         \n")
     cat("     v_F = volume of distribution/bioavailability (L)               \n")
     cat("     Ctss_pr = predicted steady-state trough conc.(mg/L)            \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     C<-pocpr(1.2,CBZMMpar$D[CBZMMpar$subject==i],CBZMMpar$tau[CBZMMpar$subject==i],CBZMMpar$tau[CBZMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)
     cat("\n**************************************************************************\n")
     }
     cal.again()
  }
  else if (pick == 5){
     cat("\n\n") 
     run()
  }      
}

#choose Digoxin population group
Dig.menu <- function()
{
  file.menu <- c("Adult",
                 "Pediatric",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Digoxin Population Menu >>")
  if (pick == 1){
     cat("\n\n")      
     Dig.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     PedDig.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}

#Adult Digoxin data file 
Dig.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Digoxin input data information--                   \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(ng/mL)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     DigSSpar<-data.frame(parameter=c("Gender","age (yr)","bw (kg)","scr (mg/dL)","D (mg)","tau (hr)","c (ng/mL)"),value=c(0))
     DigSSpar<-edit(DigSSpar)
     DigSSpar<-ycheck(DigSSpar)
     cat("\n")
     Dig.ss(DigSSpar[7,2],DigSSpar[6,2],DigSSpar[5,2],DigSSpar[4,2],DigSSpar[3,2],DigSSpar[2,2],DigSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Digoxin output data information--                    \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(ng/mL) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Digcpr(DigSSpar[5,2],DigSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (ng/mL)")
     show(coutput)
     cat("\n") 
     Dig.more(DigSSpar,coutput)
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Digoxin input data information--                   \n")
     cat("    Gender = Male=1 ; Female=0                           \n")
     cat("    age = age(yr)                                        \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    scr = serum creatinine conc.(mg/dL)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(ng/mL)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     DigMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),bw=c(0),scr=c(0),D=c(0),tau=c(0),c=c(0))
     DigMSpar<-edit(DigMSpar)
     DigMSpar<-ymscheck(DigMSpar)
     cat("\n")
     Dig.ms(length(DigMSpar$subject),DigMSpar$c,DigMSpar$tau,DigMSpar$D,DigMSpar$scr,DigMSpar$bw,DigMSpar$age,DigMSpar$Gender)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Digoxin output data information--                    \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(ng/mL) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-Digcpr(DigMSpar$D,DigMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (ng/mL)")
     show(coutput)  
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Digms.pkoutput(DigMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     Dig.menu()
  }      
}



#choose Pediatric Digoxin data file,estimate PK parameter and calculate dose adjustment 
PedDig.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Pediatric Digoxin input data information--         \n")
     cat("    age = age (month)                                    \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mcg)               \n")  
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     PedDigSSpar<-data.frame(parameter=c("age (month)","bw (kg)","D (mcg)","tau (hr)","c (mcg/L)"),value=c(0))
     PedDigSSpar<-edit(PedDigSSpar)
     PedDigSSpar<-zcheck(PedDigSSpar)
     cat("\n")
     PedDig.ss(PedDigSSpar[5,2],PedDigSSpar[4,2],PedDigSSpar[3,2],PedDigSSpar[2,2],PedDigSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Pediatric Digoxin output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr/kg)              \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")     
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-PedDigcpr(PedDigSSpar[2,2],PedDigSSpar[3,2],PedDigSSpar[4,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/L)")
     show(coutput)
     cat("\n")
     PedDig.more(PedDigSSpar[2,2],PedDigSSpar,coutput)
  } 
   else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Pediatric Digoxin input data information--         \n")
     cat("    age = age (month)                                    \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mcg)               \n")  
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("                                                         \n")     
     cat("    --Pediatric Digoxin output data information--        \n")
     cat("    cl_F = clerance/bioavailability (L/hr/kg)               \n")  
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     PedDigMSpar<-data.frame(subject=c(1,2),age=c(0),bw=c(0),D=c(0),tau=c(0),c=c(0))
     PedDigMSpar<-edit(PedDigMSpar)
     PedDigMSpar<-zmscheck(PedDigMSpar)
     cat("\n")
     PedDig.ms(length(PedDigMSpar$subject),PedDigMSpar$c,PedDigMSpar$tau,PedDigMSpar$D,PedDigMSpar$bw,PedDigMSpar$age)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Pediatric Digoxin output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr/kg)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")     
     cat("***********************************************************\n")    
     show(samplesStats("*"))
     cat("\n")
     C<-PedDigcpr(PedDigMSpar$bw,PedDigMSpar$D,PedDigMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/L)")
     show(coutput)  
     cat("\n")
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     PedDigms.pkoutput(PedDigMSpar$bw,PedDigMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     Dig.menu()
  }      
}

#choose Litium salts menu 
Lit.menu <- function()
{
  file.menu <- c("Lithium carbonate",
                 "Lithium citrate",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Lithium Menu >>")
  if (pick == 1){
     cat("\n\n")      
     Lit.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Litcit.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}


#Lithium carbonate data file 
Lit.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Lithium carbonate input data information--         \n")
     cat("    age = age (yr)                                       \n") 
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")    
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     LitSSpar<-data.frame(parameter=c("age (yr)","f","bw (kg)","Scr (mg/dL)","D (mg)","tau (hr)","c (mEq/L)"),value=c(0))
     LitSSpar<-edit(LitSSpar)
     LitSSpar<-ycheck(LitSSpar)
     cat("\n")
     Lit.ss(LitSSpar[7,2],LitSSpar[6,2],LitSSpar[1,2],LitSSpar[5,2],LitSSpar[4,2],LitSSpar[3,2],LitSSpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Lithium carbonate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Litcpr(LitSSpar[5,2],LitSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mEq/L)")
     show(coutput)
     cat("\n")   
     Lit.more(LitSSpar,coutput)
  } 
  else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Lithium carbonate input data information--         \n")
     cat("    age = age (yr)                                       \n")  
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")   
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     LitMSpar<-data.frame(subject=c(1,2),age=c(0),f=c(0),bw=c(0),Scr=c(0),D=c(0),tau=c(0),c=c(0))
     LitMSpar<-edit(LitMSpar)
     LitMSpar<-ymscheck(LitMSpar)
     cat("\n")
     Lit.ms(length(LitMSpar$subject),LitMSpar$c,LitMSpar$tau,LitMSpar$age,LitMSpar$D,LitMSpar$Scr,LitMSpar$bw,LitMSpar$f)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Lithium carbonate output data information--          \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-Litcpr(LitMSpar$D,LitMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mEq/L)")
     show(coutput)  
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Litms.pkoutput(LitMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     Lit.menu()
  }      
}

#Lithium citrate data file 
Litcit.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Lithium citrate input data information--           \n")
     cat("    age = age (yr)                                       \n") 
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     LitcitSSpar<-data.frame(parameter=c("age (yr)","f","bw (kg)","Scr (mg/dL)","D (mg)","tau (hr)","c (mEq/L)"),value=c(0))
     LitcitSSpar<-edit(LitcitSSpar)
     LitcitSSpar<-ycheck(LitcitSSpar)
     cat("\n")
     Litcit.ss(LitcitSSpar[7,2],LitcitSSpar[6,2],LitcitSSpar[1,2],LitcitSSpar[5,2],LitcitSSpar[4,2],LitcitSSpar[3,2],LitcitSSpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Lithium citrate output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Litcitcpr(LitcitSSpar[5,2],LitcitSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mEq/L)")
     show(coutput)
     cat("\n")
     Litcit.more(LitcitSSpar,coutput)
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Lithium citrate input data information--           \n")
     cat("    age = age (yr)                                       \n")  
     cat("    f = age<50 (Y=0,N=1)                                 \n") 
     cat("    bw = body weight(kg)                                 \n")
     cat("    Scr = serum creatinine conc (mg/dL)                  \n")   
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mEq/L)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     LitcitMSpar<-data.frame(subject=c(1,2),age=c(0),f=c(0),bw=c(0),Scr=c(0),D=c(0),tau=c(0),c=c(0))
     LitcitMSpar<-edit(LitcitMSpar)
     LitcitMSpar<-ymscheck(LitcitMSpar)
     cat("\n")
     Litcit.ms(length(LitcitMSpar$subject),LitcitMSpar$c,LitcitMSpar$tau,LitcitMSpar$age,LitcitMSpar$D,LitcitMSpar$Scr,LitcitMSpar$bw,LitcitMSpar$f)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Lithium citrate output data information--            \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mEq/L) \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-Litcitcpr(LitcitMSpar$D,LitcitMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mEq/L)")
     show(coutput)  
     cat("\n")   
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Litcitms.pkoutput(LitcitMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     Lit.menu()
  }      
}


# Phenytoin data file 
Phe.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Phenytoin input data information--                 \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     PheSSpar<-data.frame(parameter=c("bw (kg)","D (mg)","tau (hr)","c (mg/L)"),value=c(0))
     PheSSpar<-edit(PheSSpar)
     PheSSpar<-zcheck(PheSSpar)
     cat("\n")
     Phe.ss(PheSSpar[4,2],PheSSpar[3,2],PheSSpar[2,2],PheSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("    --Phenytoin output data information--                \n")
     cat("    Vamx = maximum rate of metabolism (mg/day)           \n")
     cat("    Km = plasma concentration at which metabolism is      \n")
     cat("         occurring at half the maximum rate (mg/L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("**********************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Phecpr(PheSSpar[2,2],PheSSpar[3,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     show(coutput)
     cat("\n")   
     Phe.more(PheSSpar,coutput)
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Phenytoin input data information--                 \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     PheMSpar<-data.frame(subject=c(1,2),bw=c(0),D=c(0),tau=c(0),c=c(0))
     PheMSpar<-edit(PheMSpar)
     PheMSpar<-zmscheck(PheMSpar)
     cat("\n")
     Phe.ms(length(PheMSpar$subject),PheMSpar$c,PheMSpar$tau,PheMSpar$D,PheMSpar$bw)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("    --Phenytoin output data information--                \n")
     cat("    Vamx = maximum rate of metabolism (mg/day)           \n")
     cat("    Km = plasma concentration at which metabolism is      \n")
     cat("         occurring at half the maximum rate (mg/L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("**********************************************************\n")   
     show(samplesStats("*"))
     cat("\n")
     C<-Phecpr(PheMSpar$D,PheMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     show(coutput)  
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Phems.pkoutput(PheMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}

#choose Valproic acid population group
Val.menu <- function()
{
  file.menu <- c("Adult",
                 "Children",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Valproic acid Population Menu >>")
  if (pick == 1){
     cat("\n\n")      
     Val.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     ChiVal.model()
  }         
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}


#choose Valproate data file, estimate PK parameter and calculate dose adjustment
ChiVal.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    TBW = total body weight (Kg)                                \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("    c = measured steady-state conc.(mg/L)                       \n")   
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValSSpar<-data.frame(parameter=c("TBW (Kg)","CBZ","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     ChiValSSpar<-edit(ChiValSSpar)
     ChiValSSpar<-ycheck(ChiValSSpar)
     ChiVal.ss(ChiValSSpar[6,2],ChiValSSpar[4,2],ChiValSSpar[5,2],ChiValSSpar[3,2],ChiValSSpar[1,2],ChiValSSpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote output data information--              \n")
     cat("    cl = clerance (L/hr)                      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)         \n")
     cat("****************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-ChiValcpr(ChiValSSpar[3,2],ChiValSSpar[4,2],ChiValSSpar[5,2],ChiValSSpar[1,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-ChiValcpr(ChiValSSpar[3,2],ChiValSSpar[4,2],ChiValSSpar[4,2],ChiValSSpar[1,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")
     ChiVal.more(ChiValSSpar[1,2],ChiValSSpar,output1,output2)
  } 
  else if (pick == 2){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    TBW = total body weight (Kg)                                \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValSMMpar<-data.frame(parameter=c("TBW (Kg)","CBZ","D (mg)","tau (hr)"),value=c(0))
     ChiValSMMpar<-edit(ChiValSMMpar)
     ChiValSMMpar<-zcheck(ChiValSMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValSMpar<-data.frame(ts=c(0),conc=c(0))
     ChiValSMpar<-edit(ChiValSMpar)
     ChiValSMpar<-mscheck(ChiValSMpar)
     cat("\n")
     ChiVal.sm(length(ChiValSMpar$ts),ChiValSMpar$conc,ChiValSMpar$ts,ChiValSMMpar[4,2],ChiValSMMpar[3,2],ChiValSMMpar[1,2],ChiValSMMpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*********************************************************\n")
     cat("    --Children Valpraote output data information--       \n")
     cat("    cl = clerance (L/hr)               \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-ChiValcpr(ChiValSMMpar[3,2],ChiValSMMpar[4,2],ChiValSMMpar[4,2],ChiValSMMpar[1,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     ChiValtwo.more(ChiValSMMpar[1,2],ChiValSMMpar,ChiValSMpar,coutput)
  }   
   else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    TBW = total body weight (Kg)                                \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("    c = measured steady-state conc.(mg/L)                       \n")  
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValMSpar<-data.frame(subject=c(1,2),TBW=c(0),CBZ=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     ChiValMSpar<-edit(ChiValMSpar)
     ChiValMSpar<-ymscheck(ChiValMSpar)
     cat("\n")
     ChiVal.ms(length(ChiValMSpar$subject),ChiValMSpar$c,ChiValMSpar$tau,ChiValMSpar$ts,ChiValMSpar$D,ChiValMSpar$TBW,ChiValMSpar$CBZ)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("****************************************************************\n")
     cat("    --Children Valpraote output data information--              \n")
     cat("    cl = clerance (L/hr)                      \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)         \n")
     cat("****************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-ChiValcpr(ChiValMSpar$D,ChiValMSpar$tau,ChiValMSpar$ts,ChiValMSpar$TBW)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-ChiValcpr(ChiValMSpar$D,ChiValMSpar$tau,ChiValMSpar$tau,ChiValMSpar$TBW)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     ChiValms.pkoutput(ChiValMSpar$TBW,ChiValMSpar,output1,output2)
     cal.again()
  } 
   else if (pick == 4){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    TBW = total body weight (Kg)                                \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValMMpar<-data.frame(subject=c(1,2),TBW=c(0),CBZ=c(0),D=c(0),tau=c(0))
     ChiValMMpar<-edit(ChiValMMpar)
     ChiValMMpar<-zmscheck(ChiValMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Children Valpraote input data information--               \n")
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ChiValMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     ChiValMMMpar<-edit(ChiValMMMpar)
     ChiValMMMpar<-mscheck(ChiValMMMpar)
     for(i in 1:length(unique(ChiValMMpar$subject))){
     k=length(ChiValMMMpar$ts[ChiValMMMpar$subject==i])
     A=ChiValMMMpar$conc[ChiValMMMpar$subject==i]
     B=ChiValMMMpar$ts[ChiValMMMpar$subject==i]
     d=ChiValMMpar$tau[ChiValMMpar$subject==i]
     e=ChiValMMpar$D[ChiValMMpar$subject==i]
     f=ChiValMMpar$TBW[ChiValMMpar$subject==i]
     g=ChiValMMpar$CBZ[ChiValMMpar$subject==i]
     ChiVal.mm(k,A,B,d,e,f,g,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                       << Subject",i,">>                           \n\n" )
     cat("    --Children Valpraote output data information--                 \n")
     cat("    cl = clerance (L/hr)                         \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)            \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-ChiValcpr(ChiValMMpar$D[ChiValMMpar$subject==i],ChiValMMpar$tau[ChiValMMpar$subject==i],ChiValMMpar$tau[ChiValMMpar$subject==i],ChiValMMpar$TBW[ChiValMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  }   
  else if (pick == 5){
     cat("\n\n") 
     Val.menu()
  }      
}




#choose Valproate data file, estimate PK parameter and calculate dose adjustment
Val.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    age = age (yr)                                              \n")   
     cat("    INDI(indication)=1 for uncontrolled epilepsy, otherwise 0   \n")
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    ka = 4 for oral solution, 1 for enteric tablet              \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ValSSpar<-data.frame(parameter=c("age (yr)","INDI","CBZ","ka","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     ValSSpar<-edit(ValSSpar)
     ValSSpar<-ycheck(ValSSpar)
     cat("\n")
     Val.ss(ValSSpar[8,2],ValSSpar[6,2],ValSSpar[7,2],ValSSpar[5,2],ValSSpar[1,2],ValSSpar[3,2],ValSSpar[2,2],ValSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*************************************************************\n")
     cat("    --Valpraote output data information--                    \n")
     cat("    cl = clerance (L/hr)                   \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)    \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)      \n")
     cat("*************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Valcpr(ValSSpar[4,2],ValSSpar[5,2],ValSSpar[6,2],ValSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Valcpr(ValSSpar[4,2],ValSSpar[5,2],ValSSpar[6,2],ValSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")   
     Val.more(ValSSpar[4,2],ValSSpar,output1,output2)
  } 
  else if (pick == 2){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    age = age (yr)                                              \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    INDI(indication)=1 for uncontrolled epilepsy, otherwise 0   \n")
     cat("    ka = 4 for oral solution, 1 for enteric tablet              \n")
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ValSMMpar<-data.frame(parameter=c("age (yr)","INDI","CBZ","ka","D (mg)","tau (hr)"),value=c(0))
     ValSMMpar<-edit(ValSMMpar)
     ValSMMpar<-ycheck(ValSMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ValSMpar<-data.frame(ts=c(0),conc=c(0))
     ValSMpar<-edit(ValSMpar)
     ValSMpar<-mscheck(ValSMpar)
     cat("\n")
     Val.sm(length(ValSMpar$ts),ValSMpar$conc,ValSMpar$ts,ValSMMpar[6,2],ValSMMpar[5,2],ValSMMpar[1,2],ValSMMpar[3,2],ValSMMpar[2,2],ValSMMpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*********************************************************\n")
     cat("    --Valpraote output data information--                \n")
     cat("    cl = clerance (L/hr)               \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Valcpr(ValSMMpar[4,2],ValSMMpar[5,2],ValSMMpar[6,2],ValSMMpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     Valtwo.more(ValSMMpar[4,2],ValSMMpar,ValSMpar,coutput)
  }   
   else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    age = age (yr)                                              \n")   
     cat("    INDI(indication)=1 for uncontrolled epilepsy, otherwise 0   \n")
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    ka = 4 for oral solution, 1 for enteric tablet              \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ValMSpar<-data.frame(subject=c(1,2),age=c(0),INDI=c(0),CBZ=c(0),ka=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     ValMSpar<-edit(ValMSpar)
     ValMSpar<-ymscheck(ValMSpar)
     Val.ms(length(ValMSpar$subject),ValMSpar$c,ValMSpar$tau,ValMSpar$ts,ValMSpar$D,ValMSpar$age,ValMSpar$CBZ,ValMSpar$INDI,ValMSpar$ka)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*************************************************************\n")
     cat("    --Valpraote output data information--                    \n")
     cat("    cl = clerance (L/hr)                   \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)    \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)      \n")
     cat("*************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Valcpr(ValMSpar$ka,ValMSpar$D,ValMSpar$tau,ValMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Valcpr(ValMSpar$ka,ValMSpar$D,ValMSpar$tau,ValMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Valms.pkoutput(ValMSpar$ka,ValMSpar,output1,output2)
     cal.again()
  } 
   else if (pick == 4){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    age = age (yr)                                              \n")   
     cat("    CBZ = combine CArbamazepine (Y=1, N=0)                      \n")
     cat("    INDI(indication)=1 for uncontrolled epilepsy, otherwise 0   \n")
     cat("    ka = 4 for oral solution, 1 for enteric tablet              \n")
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("****************************************************************\n\n")
     ValMMpar<-data.frame(subject=c(1,2),age=c(0),INDI=c(0),CBZ=c(0),ka=c(0),D=c(0),tau=c(0))
     ValMMpar<-edit(ValMMpar)
     ValMMpar<-ymscheck(ValMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Valpraote input data information--                        \n")
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("    ts = sampling time (hr)                                     \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ValMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     ValMMMpar<-edit(ValMMMpar)
     ValMMMpar<-mscheck(ValMMMpar)
     for(i in 1:length(unique(ValMMpar$subject))){
     k=length(ValMMMpar$ts[ValMMMpar$subject==i])
     A=ValMMMpar$conc[ValMMMpar$subject==i]
     B=ValMMMpar$ts[ValMMMpar$subject==i]
     d=ValMMpar$tau[ValMMpar$subject==i]
     e=ValMMpar$D[ValMMpar$subject==i]
     f=ValMMpar$age[ValMMpar$subject==i]
     g=ValMMpar$CBZ[ValMMpar$subject==i]
     h=ValMMpar$INDI[ValMMpar$subject==i]
     J=ValMMpar$ka[ValMMpar$subject==i]
     Val.mm(k,A,B,d,e,f,g,h,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                     << Subject",i,">>                           \n\n" )
     cat("    --Valpraote output data information--                        \n")
     cat("    cl = clerance (L/hr)                       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)          \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Valcpr(ValMMpar$ka[ValMMpar$subject==i],ValMMpar$D[ValMMpar$subject==i],ValMMpar$tau[ValMMpar$subject==i],ValMMpar$tau[ValMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  }   
  else if (pick == 5){
     cat("\n\n") 
     Val.menu()
  }      
}

#Vancomycin data file 
Van.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("************************************************************\n")
     cat("    --Vancomycin input data information--                   \n")
     cat("    Gender = 1 for Male ; 0 for Female                      \n")
     cat("    age = age(yr)                                           \n")
     cat("    bw = body weight (kg)                                   \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                     \n")
     cat("    D = dose for each dosing interval(mg)                   \n")
     cat("    tau = dosing interval(hr)                               \n")
     cat("    tin = infusion time(hr)                                 \n") 
     cat("    ts = sampling time since infusion end (hr)              \n") 
     cat("    c = measured steady-state conc.(mg/L)                   \n")
     cat("************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanSSpar<-data.frame(parameter=c("Gender","age (yr)","bw (kg)","Scr (mg/dL)","D (mg)","tau (hr)","tin (hr)","ts (hr)","c (mg/L)"),value=c(0))
     VanSSpar<-edit(VanSSpar)
     VanSSpar<-ycheck(VanSSpar)
     cat("\n")
     Van.ss(VanSSpar[9,2],VanSSpar[6,2],VanSSpar[8,2],VanSSpar[7,2],VanSSpar[5,2],VanSSpar[3,2],VanSSpar[4,2],VanSSpar[1,2],VanSSpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("************************************************************\n")
     cat("    --Vancomycin output data information--                  \n")
     cat("    cl = clerance (L/hr)                  \n")
     cat("    V = volume of distribution (L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("************************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(VanSSpar[5,2],VanSSpar[7,2],VanSSpar[6,2],VanSSpar[8,2]+VanSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)    
     C<-infcpr(VanSSpar[5,2],VanSSpar[7,2],VanSSpar[6,2],VanSSpar[6,2])/(exp(-(samplesStats("cl")/samplesStats("v"))*(VanSSpar[6,2]-(VanSSpar[7,2]+1))))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-infcpr(VanSSpar[5,2],VanSSpar[7,2],VanSSpar[6,2],VanSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)     
     cat("\n")   
     Van.more(VanSSpar,output1,output2,output3)
  } 
   else if (pick == 2){
     cat("\n")
     cat("*******************************************************\n")
     cat("    --Vancomycin input data information--              \n")
     cat("    Gender = 1 for Male ; 0 for Female                 \n")
     cat("    age = age(yr)                                      \n")
     cat("    bw = body weight (kg)                              \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                \n")
     cat("    D = dose for each dosing interval(mg)              \n")
     cat("    tau = dosing interval(hr)                          \n")
     cat("    tin = infusion time(hr)                            \n") 
     cat("*******************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanSMMpar<-data.frame(parameter=c("Gender","age (yr)","bw (kg)","Scr (mg/dL)","D (mg)","tau (hr)","tin (hr)"),value=c(0))
     VanSMMpar<-edit(VanSMMpar)
     VanSMMpar<-ycheck(VanSMMpar)
     cat("\n")
     cat("********************************************************\n")
     cat("    --Vancomycin input data information--               \n")
     cat("    c = measured steady-state conc.(mg/L)               \n")
     cat("    ts = sampling time since infusion end (hr)          \n") 
     cat("********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanSMpar<-data.frame(ts=c(0),conc=c(0))
     VanSMpar<-edit(VanSMpar)
     VanSMpar<-mscheck(VanSMpar)
     cat("\n")
     Van.sm(length(VanSMpar$ts),VanSMpar$conc,VanSMpar$ts,VanSMMpar[6,2],VanSMMpar[7,2],VanSMMpar[5,2],VanSMMpar[3,2],VanSMMpar[4,2],VanSMMpar[1,2],VanSMMpar[2,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Vancomycin output data information--               \n")
     cat("    cl = clerance (L/hr)               \n")
     cat("    V = volume of distribution (L)     \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(VanSMMpar[5,2],VanSMMpar[7,2],VanSMMpar[6,2],VanSMMpar[6,2])/(exp(-(samplesStats("cl")/samplesStats("v"))*(VanSMMpar[6,2]-(VanSMMpar[7,2]+1))))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-infcpr(VanSMMpar[5,2],VanSMMpar[7,2],VanSMMpar[6,2],VanSMMpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)     
     cat("\n")
     Vansm.more(VanSMMpar,VanSMpar,output1,output2)
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*******************************************************\n")
     cat("    --Vancomycin input data information--              \n")
     cat("    Gender = 1 for Male ; 0 for Female                 \n")
     cat("    age = age(yr)                                      \n")
     cat("    bw = body weight (kg)                              \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                \n")
     cat("    D = dose for each dosing interval(mg)              \n")
     cat("    tau = dosing interval(hr)                          \n")
     cat("    tin = infusion time(hr)                            \n") 
     cat("    ts = sampling time since infusion end (hr)         \n") 
     cat("    c = measured steady-state conc.(mg/L)              \n")     
     cat("*******************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanMSpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),bw=c(0),Scr=c(0),D=c(0),tau=c(0),tin=c(0),ts=c(0),c=c(0))
     VanMSpar<-edit(VanMSpar)
     VanMSpar<-ymscheck(VanMSpar)
     cat("\n")
     Van.ms(length(VanMSpar$subject),VanMSpar$c,VanMSpar$tau,VanMSpar$ts,VanMSpar$tin,VanMSpar$D,VanMSpar$bw,VanMSpar$Scr,VanMSpar$Gender,VanMSpar$age)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*********************************************************\n")
     cat("    --Vancomycin output data information--             \n")
     cat("    cl = clerance (L/hr)             \n")
     cat("    V = volume of distribution (L)   \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(VanMSpar$D,VanMSpar$tin,VanMSpar$tau,VanMSpar$ts+VanMSpar$tin)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)  
     C<-infcpr(VanMSpar$D,VanMSpar$tin,VanMSpar$tau,VanMSpar$tau)/(exp(-(samplesStats("cl")/samplesStats("v"))*(VanMSpar$tau-(VanMSpar$tin+1))))
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     output2<-coutput
     show(coutput)
     C<-infcpr(VanMSpar$D,VanMSpar$tin,VanMSpar$tau,VanMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Vanms.pkoutput(VanMSpar,output1,output2,output3)
     cal.again()
  }
  else if (pick == 4){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Vancomycin input data information--                       \n")
     cat("    Gender = 1 for Male ; 0 for Female                          \n")
     cat("    age = age(yr)                                               \n")
     cat("    bw = body weight (kg)                                       \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                         \n")
     cat("    D = dose for each dosing interval(mg)                       \n")
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    tin = infusion time(hr)                                     \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanMMpar<-data.frame(subject=c(1,2),Gender=c(0),age=c(0),bw=c(0),Scr=c(0),D=c(0),tau=c(0),tin=c(0))
     VanMMpar<-edit(VanMMpar)
     VanMMpar<-ymscheck(VanMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Vancomycin input data information--                       \n")
     cat("    c = measured steady-state conc.(mg/L)                       \n")
     cat("    ts = sampling time since infusion end (hr)                  \n") 
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     VanMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     VanMMMpar<-edit(VanMMMpar)
     VanMMMpar<-mscheck(VanMMMpar)
     for(i in 1:length(unique(VanMMpar$subject))){
     k=length(VanMMMpar$ts[VanMMMpar$subject==i])
     A=VanMMMpar$conc[VanMMMpar$subject==i]
     B=VanMMMpar$ts[VanMMMpar$subject==i]
     d=VanMMpar$tau[VanMMpar$subject==i]
     e=VanMMpar$tin[VanMMpar$subject==i]
     f=VanMMpar$D[VanMMpar$subject==i]
     g=VanMMpar$bw[VanMMpar$subject==i]
     h=VanMMpar$Scr[VanMMpar$subject==i]
     l=VanMMpar$Gender[VanMMpar$subject==i]
     J=VanMMpar$age[VanMMpar$subject==i]
     Van.mm(k,A,B,d,e,f,g,h,l,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                        << Subject",i,">>                           \n\n" )
     cat("    --Vancomycin output data information--                          \n")
     cat("    cl = clerance (L/hr)                          \n")
     cat("    V = volume of distribution (L)                 \n")
     cat("    Cpss_pr = predicted steady-state peak conc.(mg/L)                \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)              \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n")
     C<-infcpr(f,e,d,d)/(exp(-(samplesStats("cl")/samplesStats("v"))*(d-(e+1))))
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cpss_pr (mg/L)")
     show(coutput)
     C<-infcpr(VanMMpar$D[VanMMpar$subject==i],VanMMpar$tin[VanMMpar$subject==i],VanMMpar$tau[VanMMpar$subject==i],VanMMpar$tau[VanMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)
     cat("\n**************************************************************************\n")
     }    
     cal.again()
     }
  else if (pick == 5){
     cat("\n\n") 
     run()
  }      
}

#choose AntiHIV drugs menu
AntiHIV.menu <- function()
{
  file.menu <- c("Enfuvirtide",
                 "Indinavir",
                 "Ritonavir",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Anti-HIV drugs Menu >>")
  if (pick == 1){
     cat("\n\n")      
     Enf.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Ind.model()
  }      
  else if (pick == 3){
     cat("\n\n") 
     Rit.model()
  }      
  else if (pick == 4){
     cat("\n\n") 
     run()
  }      
}

#Enfuvirtide data file choose
Enf.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    Gender : 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfSSpar<-data.frame(parameter=c("Gender","bw (kg)","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     EnfSSpar<-edit(EnfSSpar)
     EnfSSpar<-ycheck(EnfSSpar)
     cat("\n")
     Enf.ss(EnfSSpar[6,2],EnfSSpar[4,2],EnfSSpar[5,2],EnfSSpar[3,2],EnfSSpar[2,2],EnfSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-pocpr(samplesStats("ka"),EnfSSpar[3,2],EnfSSpar[4,2],EnfSSpar[5,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-pocpr(samplesStats("ka"),EnfSSpar[3,2],EnfSSpar[4,2],EnfSSpar[4,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")  
     Enf.more(EnfSSpar,output1,output2)
  } 
    else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    Gender : 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfSMMpar<-data.frame(parameter=c("Gender","bw (kg)","D (mg)","tau (hr)"),value=c(0))
     EnfSMMpar<-edit(EnfSMMpar)
     EnfSMMpar<-zcheck(EnfSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfSMpar<-data.frame(ts=c(0),conc=c(0))
     EnfSMpar<-edit(EnfSMpar)
     EnfSMpar<-mscheck(EnfSMpar)
     cat("\n")
     Enf.sm(length(EnfSMpar$ts),EnfSMpar$conc,EnfSMpar$ts,EnfSMMpar[4,2],EnfSMMpar[3,2],EnfSMMpar[2,2],EnfSMMpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*********************************************************\n")
     cat("    --Enfuvirtide output data information--              \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n")  
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-pocpr(samplesStats("ka"),EnfSMMpar[3,2],EnfSMMpar[4,2],EnfSMMpar[4,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     Enfsm.more(EnfSMMpar,EnfSMpar,coutput)
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("**********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    Gender : 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("**********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfMSpar<-data.frame(subject=c(1,2),Gender=c(0),bw=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     EnfMSpar<-edit(EnfMSpar)
     EnfMSpar<-ymscheck(EnfMSpar)
     cat("\n")
     Enf.ms(length(EnfMSpar$subject),EnfMSpar$c,EnfMSpar$tau,EnfMSpar$ts,EnfMSpar$D,EnfMSpar$bw,EnfMSpar$Gender)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("    --Enfuvirtide output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                \n")
     cat("    V_F = volume of distribution/bioavailability (L)      \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)  \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-pocpr(samplesStats("ka"),EnfMSpar$D,EnfMSpar$tau,EnfMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-pocpr(samplesStats("ka"),EnfMSpar$D,EnfMSpar$tau,EnfMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Enfms.pkoutput(EnfMSpar,output1,output2)
     cal.again()
  }
  else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    Gender : 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfMMpar<-data.frame(subject=c(1,2),Gender=c(0),bw=c(0),D=c(0),tau=c(0))
     EnfMMpar<-edit(EnfMMpar)
     EnfMMpar<-zmscheck(EnfMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Enfuvirtide input data information--               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnfMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     EnfMMMpar<-edit(EnfMMMpar)
     EnfMMMpar<-mscheck(EnfMMMpar)
     for(i in 1:length(unique(EnfMMpar$subject))){
     h=length(EnfMMMpar$ts[EnfMMMpar$subject==i])
     A=EnfMMMpar$conc[EnfMMMpar$subject==i]
     B=EnfMMMpar$ts[EnfMMMpar$subject==i]
     d=EnfMMpar$tau[EnfMMpar$subject==i]
     e=EnfMMpar$D[EnfMMpar$subject==i]
     f=EnfMMpar$bw[EnfMMpar$subject==i]
     g=EnfMMpar$Gender[EnfMMpar$subject==i]
     Enf.mm(h,A,B,d,e,f,g,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                    << Subject",i,">>                           \n\n" )
     cat("    --Enfuvirtide output data information--                      \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                       \n")
     cat("    V_F = volume of distribution/bioavailability (L)             \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr)       \n")  
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)        \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-pocpr(samplesStats("ka"),EnfMMpar$D[EnfMMpar$subject==i],EnfMMpar$tau[EnfMMpar$subject==i],EnfMMpar$tau[EnfMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     AntiHIV.menu()
  }      
}

#Indinavir data file
Ind.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    Gender = 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")    
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndSSpar<-data.frame(parameter=c("Gender","bw (kg)","Rit","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     IndSSpar<-edit(IndSSpar)
     IndSSpar<-ycheck(IndSSpar)
     Ind.ss(IndSSpar[7,2],IndSSpar[5,2],IndSSpar[6,2],IndSSpar[4,2],IndSSpar[2,2],IndSSpar[3,2],IndSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Indcpr(samplesStats("ka"),IndSSpar[4,2],IndSSpar[5,2],IndSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Indcpr(samplesStats("ka"),IndSSpar[4,2],IndSSpar[5,2],IndSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")  
     Ind.more(IndSSpar,output1,output2)
  } 
    else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    Gender = 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndSMMpar<-data.frame(parameter=c("Gender","bw (kg)","Rit","D (mg)","tau (hr)"),value=c(0))
     IndSMMpar<-edit(IndSMMpar)
     IndSMMpar<-zcheck(IndSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndSMpar<-data.frame(ts=c(0),conc=c(0))
     IndSMpar<-edit(IndSMpar)
     IndSMpar<-mscheck(IndSMpar)
     cat("\n")
     Ind.sm(length(IndSMpar$ts),IndSMpar$conc,IndSMpar$ts,IndSMMpar[5,2],IndSMMpar[4,2],IndSMMpar[2,2],IndSMMpar[3,2],IndSMMpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Indcpr(samplesStats("ka"),IndSMMpar[4,2],IndSMMpar[5,2],IndSMMpar[5,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     Indsm.more(IndSMMpar,IndSMpar,coutput)
  } 
     else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    Gender = 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndMSpar<-data.frame(subject=c(1,2),Gender=c(0),bw=c(0),Rit=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     IndMSpar<-edit(IndMSpar)
     IndMSpar<-ymscheck(IndMSpar)
     cat("\n")
     Ind.ms(length(IndMSpar$subject),IndMSpar$c,IndMSpar$tau,IndMSpar$ts,IndMSpar$D,IndMSpar$bw,IndMSpar$Rit,IndMSpar$Gender)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("*********************************************************\n")
     cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Indcpr(samplesStats("ka"),IndMSpar$D,IndMSpar$tau,IndMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Indcpr(samplesStats("ka"),IndMSpar$D,IndMSpar$tau,IndMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Indms.pkoutput(IndMSpar,output1,output2)
     cal.again()
  }
  else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    Gender = 1 for Male ; 0 for Female                   \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    Rit = combine Ritonavir(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndMMpar<-data.frame(subject=c(1,2),Gender=c(0),bw=c(0),Rit=c(0),D=c(0),tau=c(0))
     IndMMpar<-edit(IndMMpar)
     IndMMpar<-zmscheck(IndMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Indinavir input data information--                 \n")
     cat("    c = measured steady-state conc.(mg/L)                \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     IndMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     IndMMMpar<-edit(IndMMMpar)
     IndMMMpar<-mscheck(IndMMMpar)
     for(i in 1:length(unique(IndMMpar$subject))){
     J=length(IndMMMpar$ts[IndMMMpar$subject==i])
     A=IndMMMpar$conc[IndMMMpar$subject==i]
     B=IndMMMpar$ts[IndMMMpar$subject==i]
     d=IndMMpar$tau[IndMMpar$subject==i]
     e=IndMMpar$D[IndMMpar$subject==i]
     f=IndMMpar$bw[IndMMpar$subject==i]
     g=IndMMpar$Rit[IndMMpar$subject==i]
     h=IndMMpar$Gender[IndMMpar$subject==i]
     Ind.mm(J,A,B,d,e,f,g,h,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                       << Subject",i,">>                            \n\n" )
     cat("    --Indinavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    ka = absorption rate constant/bioavailability (1/hr) \n") 
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Indcpr(samplesStats("ka"),IndMMpar$D[IndMMpar$subject==i],IndMMpar$tau[IndMMpar$subject==i],IndMMpar$tau[IndMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)   
     cat("\n**************************************************************************\n")
     }   
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     AntiHIV.menu()
  }      
}

#Ritonavir data file
Rit.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)                    \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-stat conc.(mg/L)                 \n")    
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitSSpar<-data.frame(parameter=c("LPV","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     RitSSpar<-edit(RitSSpar)
     RitSSpar<-zcheck(RitSSpar)
     cat("\n")
     Rit.ss(RitSSpar[5,2],RitSSpar[4,2],RitSSpar[3,2],RitSSpar[2,2],RitSSpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Ritcpr(samplesStats("ka"),RitSSpar[2,2],RitSSpar[3,2],RitSSpar[4,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Ritcpr(samplesStats("ka"),RitSSpar[2,2],RitSSpar[3,2],RitSSpar[3,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")   
     Rit.more(RitSSpar,output1,output2)
  } 
    else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)                    \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitSMMpar<-data.frame(parameter=c("LPV","D (mg)","tau (hr)"),value=c(0))
     RitSMMpar<-edit(RitSMMpar)
     RitSMMpar<-wcheck(RitSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    c = measured steady-stat conc.(mg/L)                 \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitSMpar<-data.frame(ts=c(0),conc=c(0))
     RitSMpar<-edit(RitSMpar)
     RitSMpar<-mscheck(RitSMpar)
     cat("\n")
     Rit.sm(length(RitSMpar$ts),RitSMpar$conc,RitSMpar$ts,RitSMMpar[3,2],RitSMMpar[2,2],RitSMMpar[1,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Ritcpr(samplesStats("ka"),RitSMMpar[2,2],RitSMMpar[3,2],RitSMMpar[3,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     Ritsm.more(RitSMMpar,RitSMpar,coutput)
  } 
    else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)                    \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-stat conc.(mg/L)                 \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitMSpar<-data.frame(subject=c(1,2),LPV=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     RitMSpar<-edit(RitMSpar)
     RitMSpar<-zmscheck(RitMSpar)
     cat("\n")
     Rit.ms(length(RitMSpar$subject),RitMSpar$c,RitMSpar$ts,RitMSpar$tau,RitMSpar$D,RitMSpar$LPV)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("    --Ritonavir output data information--                \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mg/L)\n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("**********************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Ritcpr(samplesStats("ka"),RitMSpar$D,RitMSpar$tau,RitMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Ritcpr(samplesStats("ka"),RitMSpar$D,RitMSpar$tau,RitMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Ritms.pkoutput(RitMSpar,output1,output2)
     cal.again()
  }
  else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    LPV = combine Lopinavir (Y=1;N=0)                    \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitMMpar<-data.frame(subject=c(1,2),LPV=c(0),D=c(0),tau=c(0))
     RitMMpar<-edit(RitMMpar)
     RitMMpar<-wmscheck(RitMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Ritonavir input data information--                 \n")
     cat("    c = measured steady-stat conc.(mg/L)                \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     RitMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     RitMMMpar<-edit(RitMMMpar)
     RitMMMpar<-mscheck(RitMMMpar)
     for(i in 1:length(unique(RitMMpar$subject))){
     g=length(RitMMMpar$ts[RitMMMpar$subject==i])
     A=RitMMMpar$conc[RitMMMpar$subject==i]
     B=RitMMMpar$ts[RitMMMpar$subject==i]
     d=RitMMpar$tau[RitMMpar$subject==i]
     e=RitMMpar$D[RitMMpar$subject==i]
     f=RitMMpar$LPV[RitMMpar$subject==i]
     Rit.mm(g,A,B,d,e,f,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                       << Subject",i,">>                        \n\n" )
     cat("    --Ritonavir output data information--                     \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                    \n")
     cat("    V_F = volume of distribution/bioavailability (L)          \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)       \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Ritcpr(samplesStats("ka"),RitMMpar$D[RitMMpar$subject==i],RitMMpar$tau[RitMMpar$subject==i],RitMMpar$tau[RitMMpar$subject==i])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     AntiHIV.menu()
  }      
}

#choose immunosuppressants menu 
Immunosuppressants.menu <- function()
{
  file.menu <- c("Cyclosporine-A",
                 "Everolimus",
                 "Tacrolimus",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< Immunosuppressants Menu >>")
  if (pick == 1){
     cat("\n\n")      
     Cyc.model()
  } 
  else if (pick == 2){
     cat("\n\n") 
     Eve.model()
  }      
  else if (pick == 3){
     cat("\n\n") 
     Tac.model()
  }      
  else if (pick == 4){
     cat("\n\n") 
     run()
  }    
}

#choose Cyclosporine-A data file, estimate PK parameters and calculate dose adjustment 
Cyc.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    PTD = post-transplant day(day)                       \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycSSpar<-data.frame(parameter=c("bw (kg)","PTD (day)","Dia","D (mg)","tau (hr)","ts (hr)","c (mcg/L)"),value=c(0))
     CycSSpar<-edit(CycSSpar)
     CycSSpar<-ycheck(CycSSpar)
     cat("\n")
     Cyc.ss(CycSSpar[7,2],CycSSpar[2,2],CycSSpar[5,2],CycSSpar[6,2],CycSSpar[4,2],CycSSpar[1,2],CycSSpar[3,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Cyccpr(CycSSpar[2,2],CycSSpar[1,2],CycSSpar[4,2],CycSSpar[5,2],CycSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Cyccpr(CycSSpar[2,2],CycSSpar[1,2],CycSSpar[4,2],CycSSpar[5,2],CycSSpar[5,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")   
     Cyc.more(CycSSpar[2,2],CycSSpar[1,2],CycSSpar,output1,output2)
  } 
   else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    PTD = post-transplant day(day)                       \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycSMMpar<-data.frame(parameter=c("bw (kg)","PTD (day)","Dia","D (mg)","tau (hr)"),value=c(0))
     CycSMMpar<-edit(CycSMMpar)
     CycSMMpar<-zcheck(CycSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    conc = measured steady-state conc.(mcg/L)            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycSMpar<-data.frame(ts=c(0),conc=c(0))
     CycSMpar<-edit(CycSMpar)
     CycSMpar<-mscheck(CycSMpar)
     cat("\n")
     Cyc.sm(length(CycSMpar$ts),CycSMpar$conc,CycSMpar$ts,CycSMMpar[2,2],CycSMMpar[5,2],CycSMMpar[4,2],CycSMMpar[1,2],CycSMMpar[3,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("**********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Cyccpr(CycSMMpar[2,2],CycSMMpar[1,2],CycSMMpar[4,2],CycSMMpar[5,2],CycSMMpar[5,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n")    
     Cyctwo.more(CycSMMpar[2,2],CycSMMpar[1,2],CycSMMpar,CycSMpar,coutput)
  } 
    else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    PTD = post-transplant day(day)                       \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycMSpar<-data.frame(subject=c(1,2),bw=c(0),PTD=c(0),Dia=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     CycMSpar<-edit(CycMSpar)
     CycMSpar<-ymscheck(CycMSpar)
     cat("\n")
     Cyc.ms(length(CycMSpar$subject),CycMSpar$c,CycMSpar$PTD,CycMSpar$tau,CycMSpar$ts,CycMSpar$D,CycMSpar$bw,CycMSpar$Dia)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("   --Cyclosporine output data information--               \n")
     cat("   cl = clerance (L/hr)                   \n")
     cat("   Cmss_pr = predicted steady-state measured conc.(mcg/L) \n")
     cat("   Ctss_pr = predicted steady-state trough conc.(mcg/L)   \n")
     cat("**********************************************************\n") 
     show(samplesStats("*"))
     cat("\n") 
     C<-Cyccpr(CycMSpar$PTD,CycMSpar$bw,CycMSpar$D,CycMSpar$tau,CycMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Cyccpr(CycMSpar$PTD,CycMSpar$bw,CycMSpar$D,CycMSpar$tau,CycMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Cycms.pkoutput(CycMSpar$PTD,CycMSpar$bw,CycMSpar,output1,output2)
     cal.again()
  }
  else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    PTD = post-transplant day(day)                       \n")
     cat("    Dia = combine Diatiazem(Y=1;N=0)                     \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycMMpar<-data.frame(subject=c(1,2),bw=c(0),PTD=c(0),Dia=c(0),D=c(0),tau=c(0))
     CycMMpar<-edit(CycMMpar)
     CycMMpar<-zmscheck(CycMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Cyclosporine input data information--              \n")
     cat("    conc = measured steady-state conc.(mcg/L)            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     CycMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     CycMMMpar<-edit(CycMMMpar)
     CycMMMpar<-mscheck(CycMMMpar)
     for(i in 1:length(unique(CycMMpar$subject))){
     J=length(CycMMMpar$ts[CycMMMpar$subject==i])
     A=CycMMMpar$conc[CycMMMpar$subject==i]
     B=CycMMMpar$ts[CycMMMpar$subject==i]
     d=CycMMpar$PTD[CycMMpar$subject==i]
     e=CycMMpar$tau[CycMMpar$subject==i]
     f=CycMMpar$D[CycMMpar$subject==i]
     g=CycMMpar$bw[CycMMpar$subject==i]
     h=CycMMpar$Dia[CycMMpar$subject==i]
     Cyc.mm(J,A,B,d,e,f,g,h,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                 << Subject",i,">>                           \n\n" )
     cat("    --Cyclosporine output data information--                 \n")
     cat("    cl = clerance (L/hr)                   \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)     \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Cyccpr(d,g,f,e,e)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Immunosuppressants.menu()
  }      
}

#Everolimus data file 
Eve.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    age = age(yr)                                        \n")
     cat("    race = 1 for black ; otherwise 0                     \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")  
     cat("*********************************************************\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveSSpar<-data.frame(parameter=c("bw (kg)","age (yr)","race","Ery","D (mg)","tau (hr)","ts (hr)","c (mcg/L)"),value=c(0))
     EveSSpar<-edit(EveSSpar)
     EveSSpar<-ycheck(EveSSpar)
     cat("\n")
     Eve.ss(EveSSpar[8,2],EveSSpar[6,2],EveSSpar[7,2],EveSSpar[5,2],EveSSpar[1,2],EveSSpar[2,2],EveSSpar[3,2],EveSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("***********************************************************\n")          
     show(samplesStats("*"))
     cat("\n") 
     C<-Evecpr(6.07,EveSSpar[5,2],EveSSpar[6,2],EveSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/L)")
     output1<-coutput
     show(coutput)
     C<-Evecpr(6.07,EveSSpar[5,2],EveSSpar[6,2],EveSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n")  
     Eve.more(EveSSpar,output1,output2)
  } 
    else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    age = age(yr)                                        \n")
     cat("    race = 1 for black ; otherwise 0                     \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveSMMpar<-data.frame(parameter=c("bw (kg)","age (yr)","race","Ery","D (mg)","tau (hr)"),value=c(0))
     EveSMMpar<-edit(EveSMMpar)
     EveSMMpar<-ycheck(EveSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveSMpar<-data.frame(ts=c(0),conc=c(0))
     EveSMpar<-edit(EveSMpar)
     EveSMpar<-mscheck(EveSMpar)
     cat("\n")
     Eve.sm(length(EveSMpar$ts),EveSMpar$conc,EveSMpar$ts,EveSMMpar[6,2],EveSMMpar[5,2],EveSMMpar[1,2],EveSMMpar[2,2],EveSMMpar[3,2],EveSMMpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Everolimus output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L) \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Evecpr(6.07,EveSMMpar[5,2],EveSMMpar[6,2],EveSMMpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/L)")
     show(coutput)    
     cat("\n") 
     Evesm.more(EveSMMpar,EveSMpar,coutput)
  } 
    else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    age = age(yr)                                        \n")
     cat("    race = 1 for black ; otherwise 0                     \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveMSpar<-data.frame(subject=c(1,2),bw=c(0),age=c(0),race=c(0),Ery=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     EveMSpar<-edit(EveMSpar)
     EveMSpar<-ymscheck(EveMSpar)
     cat("\n\n")
     Eve.ms(length(EveMSpar$subject),EveMSpar$c,EveMSpar$tau,EveMSpar$ts,EveMSpar$D,EveMSpar$bw,EveMSpar$age,EveMSpar$race,EveMSpar$Ery)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***********************************************************\n")
     cat("    --Everolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/L)  \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)    \n")
     cat("***********************************************************\n")      
     show(samplesStats("*"))
     cat("\n") 
     C<-Evecpr(6.07,EveMSpar$D,EveMSpar$tau,EveMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/L)")
     output1<-coutput
     show(coutput)
     C<-Evecpr(6.07,EveMSpar$D,EveMSpar$tau,EveMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/L)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Evems.pkoutput(EveMSpar,output1,output2)
     cal.again()
  }
   else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    bw = body weight(kg)                                 \n")
     cat("    age = age(yr)                                        \n")
     cat("    race = 1 for black ; otherwise 0                     \n")
     cat("    Ery = combine Erythromycin(Y=1;N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveMMpar<-data.frame(subject=c(1,2),bw=c(0),age=c(0),race=c(0),Ery=c(0),D=c(0),tau=c(0))
     EveMMpar<-edit(EveMMpar)
     EveMMpar<-ymscheck(EveMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Everolimus input data information--                \n")
     cat("    c = measured steady-state conc.(mcg/L)               \n")
     cat("    ts = sampling time(hr)                               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EveMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     EveMMMpar<-edit(EveMMMpar)
     EveMMMpar<-mscheck(EveMMMpar)
     for(i in 1:length(unique(EveMMpar$subject))){
     a=length(EveMMMpar$ts[EveMMMpar$subject==i])
     b=EveMMMpar$conc[EveMMMpar$subject==i]
     C=EveMMMpar$ts[EveMMMpar$subject==i]
     d=EveMMpar$tau[EveMMpar$subject==i]
     e=EveMMpar$D[EveMMpar$subject==i]
     f=EveMMpar$bw[EveMMpar$subject==i]
     g=EveMMpar$age[EveMMpar$subject==i]
     h=EveMMpar$race[EveMMpar$subject==i]
     J=EveMMpar$Ery[EveMMpar$subject==i]
     Eve.mm(a,b,C,d,e,f,g,h,J,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                        << Subject",i,">>                           \n\n" )
     cat("    --Everolimus output data information--                     \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                     \n")
     cat("    V_F = volume of distribution/bioavailability (L)           \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/L)       \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Evecpr(6.07,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/L)")
     show(coutput)    
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Immunosuppressants.menu()
  }      
}

#Tacrolimus data file 
Tac.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1           \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1          \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                    \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")  
     cat("    c = measured steady-state conc.(mcg/mL)               \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacSSpar<-data.frame(parameter=c("Hem","Alb","Dil","Flu","D (mg)","tau (hr)","ts (hr)","c (mcg/mL)"),value=c(0))
     TacSSpar<-edit(TacSSpar)
     TacSSpar<-ycheck(TacSSpar)
     cat("\n")
     Tac.ss(TacSSpar[8,2],TacSSpar[6,2],TacSSpar[7,2],TacSSpar[5,2],TacSSpar[1,2],TacSSpar[2,2],TacSSpar[3,2],TacSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("************************************************************\n")
     cat("    --Tacrolimus output data information--                  \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("    V_F = volume of distribution/bioavailability (L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/mL) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Taccpr(4.5,TacSSpar[5,2],TacSSpar[6,2],TacSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/mL)")
     output1<-coutput
     show(coutput)
     C<-Taccpr(4.5,TacSSpar[5,2],TacSSpar[6,2],TacSSpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/mL)")
     output2<-output
     show(coutput)    
     cat("\n")   
     Tac.more(TacSSpar,output1,output2)
  } 
    else if (pick == 2){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1           \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1          \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                    \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacSMMpar<-data.frame(parameter=c("Hem","Alb","Dil","Flu","D (mg)","tau (hr)"),value=c(0))
     TacSMMpar<-edit(TacSMMpar)
     TacSMMpar<-ycheck(TacSMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    c = measured steady-state conc.(mcg/mL)              \n")
     cat("    ts = sampling time(hr)                               \n")  
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacSMpar<-data.frame(ts=c(0),conc=c(0))
     TacSMpar<-edit(TacSMpar)
     TacSMpar<-mscheck(TacSMpar)
     cat("\n")
     Tac.sm(length(TacSMpar$ts),TacSMpar$conc,TacSMpar$ts,TacSMMpar[6,2],TacSMMpar[5,2],TacSMMpar[1,2],TacSMMpar[2,2],TacSMMpar[3,2],TacSMMpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("***********************************************************\n")
     cat("    --Tacrolimus output data information--                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)       \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/mL)  \n")
     cat("***********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Taccpr(4.5,TacSMMpar[5,2],TacSMMpar[6,2],TacSMMpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/mL)")
     show(coutput)    
     cat("\n")      
     Tacsm.more(TacSMMpar,TacSMpar,coutput)
  } 
    else if (pick == 3){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1           \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1          \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                    \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("    ts = sampling time(hr)                               \n")  
     cat("    c = measured steady-state conc.(mcg/mL)              \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacMSpar<-data.frame(subject=c(1,2),Hem=c(0),Alb=c(0),Dil=c(0),Flu=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     TacMSpar<-edit(TacMSpar)
     TacMSpar<-ymscheck(TacMSpar)
     cat("\n")
     Tac.ms(length(TacMSpar$subject),TacMSpar$c,TacMSpar$tau,TacMSpar$ts,TacMSpar$D,TacMSpar$Hem,TacMSpar$Alb,TacMSpar$Dil,TacMSpar$Flu)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("************************************************************\n")
     cat("    --Tacrolimus output data information--                  \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                  \n")
     cat("    V_F = volume of distribution/bioavailability (L)        \n")
     cat("    Cmss_pr = predicted steady-state measured conc.(mcg/mL) \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/mL)   \n")
     cat("************************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Taccpr(4.5,TacMSpar$D,TacMSpar$tau,TacMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cmss_pr (mcg/mL)")
     output1<-coutput
     show(coutput)
     C<-Taccpr(4.5,TacMSpar$D,TacMSpar$tau,TacMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/mL)")
     output2<-coutput
     show(coutput)    
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Tacms.pkoutput(TacMSpar,output1,output2)
     cal.again()
  }
   else if (pick == 4){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    Hem = 0 for hematocrit < 30% , otherwise 1           \n")   
     cat("    Alb = 0 for albumin < 3.5g/dL , otherwise 1          \n") 
     cat("    Dil = combine Diltiazem(Y=1, N=0)                    \n")
     cat("    Flu = combine Fluconazole(Y=1, N=0)                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(hr)                            \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacMMpar<-data.frame(subject=c(1,2),Hem=c(0),Alb=c(0),Dil=c(0),Flu=c(0),D=c(0),tau=c(0))
     TacMMpar<-edit(TacMMpar)
     TacMMpar<-ymscheck(TacMMpar)
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Tacrolimus input data information--                \n")
     cat("    c = measured steady-state conc.(mcg/mL)              \n")
     cat("    ts = sampling time(hr)                               \n")  
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     TacMMMpar<-data.frame(subject=c(1),ts=c(0),conc=c(0))
     TacMMMpar<-edit(TacMMMpar)
     TacMMMpar<-mscheck(TacMMMpar)
     for(i in 1:length(unique(TacMMpar$subject))){
     J=length(TacMMMpar$ts[TacMMMpar$subject==i])
     A=TacMMMpar$conc[TacMMMpar$subject==i]
     B=TacMMMpar$ts[TacMMMpar$subject==i]
     d=TacMMpar$tau[TacMMpar$subject==i]
     e=TacMMpar$D[TacMMpar$subject==i]
     f=TacMMpar$Hem[TacMMpar$subject==i]
     g=TacMMpar$Alb[TacMMpar$subject==i]
     h=TacMMpar$Dil[TacMMpar$subject==i]
     l=TacMMpar$Flu[TacMMpar$subject==i]
     Tac.mm(J,A,B,d,e,f,g,h,l,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                        << Subject",i,">>                           \n\n" )
     cat("    --Tacrolimus output data information--                     \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                    \n")
     cat("    V_F = volume of distribution/bioavailability (L)          \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mcg/mL)     \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Taccpr(4.5,e,d,d)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mcg/mL)")
     show(coutput) 
     cat("\n**************************************************************************\n")
     }
     cal.again()
  } 
  else if (pick == 5){
     cat("\n\n") 
     Immunosuppressants.menu()
  }      
}

#Enoxaparin data file
Eno.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*************************************************************\n")
     cat("    --Enoxaparin input data information--                    \n")
     cat("    Gender = 1 for Male ; 0 for Female                       \n") 
     cat("    TBW = body weight(kg)                                    \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                      \n")
     cat("    D = dose for each dosing interval(IU); 1mg = 100 IU      \n")
     cat("    tau = dosing interval(hr)                                \n")
     cat("    Amax = anti-Xa maximal activity at stedy state (IU/mL)   \n")
     cat("*************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnoSSpar<-data.frame(parameter=c("Gender","TBW (kg)","Scr (mg/dL)","D (IU)","tau (hr)","Amax (IU/mL)"),value=c(0))
     EnoSSpar<-edit(EnoSSpar)
     EnoSSpar<-ycheck(EnoSSpar)
     cat("\n")
     Eno.ss(EnoSSpar[6,2],EnoSSpar[5,2],EnoSSpar[4,2],EnoSSpar[2,2],EnoSSpar[1,2],EnoSSpar[3,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***************************************************************************\n")
     cat("    --Enoxaparin output data information--                                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)                       \n")
     cat("    Amaxss_pr = predicted anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("***************************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Enocpr(EnoSSpar[4,2],EnoSSpar[5,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Amaxss_pr (IU/mL) ")
     show(coutput)
     cat("\n") 
     Eno.more(EnoSSpar,coutput)
  } 
   else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*************************************************************\n")
     cat("    --Enoxaparin input data information--                    \n")
     cat("    Gender = 1 for Male ; 0 for Female                       \n") 
     cat("    TBW = body weight(kg)                                    \n")   
     cat("    Scr = serum creatinine conc.(mg/dL)                      \n")
     cat("    D = dose for each dosing interval(IU); 1mg = 100 IU      \n")
     cat("    tau = dosing interval(hr)                                \n")
     cat("    Amax = anti-Xa maximal activity at stedy state (IU/mL)   \n")
     cat("*************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     EnoMSpar<-data.frame(subject=c(1,2),Gender=c(0),TBW=c(0),Scr=c(0),D=c(0),tau=c(0),Amax=c(0))
     EnoMSpar<-edit(EnoMSpar)
     EnoMSpar<-ymscheck(EnoMSpar)
     cat("\n")
     Eno.ms(length(EnoMSpar$subject),EnoMSpar$Amax,EnoMSpar$tau,EnoMSpar$D,EnoMSpar$TBW,EnoMSpar$Gender,EnoMSpar$Scr)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("***************************************************************************\n")
     cat("    --Enoxaparin output data information--                                 \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                                 \n")
     cat("    V_F = volume of distribution/bioavailability (L)                       \n")
     cat("    Amaxss_pr = predicted anti-Xa maximal activity at stedy state (IU/mL)  \n")
     cat("***************************************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Enocpr(EnoMSpar$D,EnoMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Amaxss_pr (IU/mL)")
     show(coutput)   
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Enoms.pkoutput(EnoMSpar,coutput)
     cal.again()
  }
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}




# choose Imatinib mesylate data file, estimate PK parameter and calculate dose adjustment
Ima.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "single subj with mutiple conc (sampling times must more than twice)",
                 "multiple subj with each single conc",
                 "multiple subj and mutiple conc (each subj's sampling times must more than twice)",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    BW = body weight(kg)                                        \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                          \n")
     cat("    Hb = Hemoglobin (g/dL)                                      \n")
     cat("    WBC = white blood count (10^9/L)                            \n")
     cat("    n = dosing number                                           \n") 
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n")
     cat("    c = measured conc.(mg/L)                                    \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("****************************************************************\n")
     cat("      ATTENTION :                                               \n")
     cat("      Sampling Time (ts) must be greater than 1.5 hr.           \n")
     cat("****************************************************************\n")
     cat("\n\n")
     cat("          Pressing Enter to continue..                          \n")
     readline()
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaSSpar<-data.frame(parameter=c("BW (kg)","OCC","Hb (g/dL)","WBC (10^9/L)","n","D (mg)","tau (hr)","ts (hr)","c (mg/L)"),value=c(0))
     ImaSSpar<-edit(ImaSSpar)
     ImaSSpar<-ycheck(ImaSSpar)
     cat("\n")
     Ima.ss(ImaSSpar[9,2],ImaSSpar[7,2],ImaSSpar[8,2],ImaSSpar[5,2],ImaSSpar[6,2],ImaSSpar[2,2],ImaSSpar[1,2],ImaSSpar[3,2],ImaSSpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                      \n")
     cat("    V_F = volume of distribution/bioavailability (L)            \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)                      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)         \n")
     cat("****************************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Imacpr(ImaSSpar[5,2],ImaSSpar[6,2],ImaSSpar[7,2],ImaSSpar[8,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Imasscpr(ImaSSpar[6,2],ImaSSpar[7,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)    
     cat("\n")   
     Ima.more(ImaSSpar,output1,output3)
  } 
  else if (pick == 2){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    BW = body weight(kg)                                        \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                          \n")
     cat("    Hb = Hemoglobin (g/dL)                                      \n")
     cat("    WBC = white blood count (10^9/L)                            \n")
     cat("    n = dosing number                                           \n") 
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaSMMpar<-data.frame(parameter=c("BW (kg)","OCC","Hb (g/dL)","WBC (10^9/L)","D (mg)","tau (hr)"),value=c(0))
     ImaSMMpar<-edit(ImaSMMpar)
     ImaSMMpar<-ycheck(ImaSMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    c = measured conc.(mg/L)                                    \n")
     cat("    ts = sampling time (hr)                                     \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("****************************************************************\n")
     cat("      ATTENTION :                                               \n")
     cat("      Sampling Time (ts) must be greater than 1.5 hr.           \n")
     cat("****************************************************************\n")
     cat("\n\n")
     cat("          Pressing Enter to continue..                          \n")
     readline()
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaSMpar<-data.frame(n=c(0),ts=c(0),conc=c(0))
     ImaSMpar<-edit(ImaSMpar)
     ImaSMpar<-mscheck(ImaSMpar)
     cat("\n")
     Ima.sm(length(ImaSMpar$ts),ImaSMpar$conc,ImaSMpar$ts,ImaSMMpar[6,2],ImaSMpar$n,ImaSMMpar[5,2],ImaSMMpar[2,2],ImaSMMpar[1,2],ImaSMMpar[3,2],ImaSMMpar[4,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("*********************************************************\n")
     cat("    --Imatinib mesylate output data information--        \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n")
     cat("*********************************************************\n")
     show(samplesStats("*"))
     cat("\n") 
     C<-Imasscpr(ImaSMMpar[5,2],ImaSMMpar[6,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n") 
     Imasm.more(ImaSMMpar,ImaSMpar,coutput)
  }   
   else if (pick == 3){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    BW = body weight(kg)                                        \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                          \n")
     cat("    Hb = Hemoglobin (g/dL)                                      \n")
     cat("    WBC = white blood count (10^9/L)                            \n")
     cat("    n = dosing number                                           \n") 
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                   \n")
     cat("    ts = sampling time (hr)                                     \n")
     cat("    c = measured conc.(mg/L)                                    \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("****************************************************************\n")
     cat("      ATTENTION :                                               \n")
     cat("      Sampling Time (ts) must be greater than 1.5 hr.           \n")
     cat("****************************************************************\n")
     cat("\n\n")
     cat("          Pressing Enter to continue..                          \n")
     readline()
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaMSpar<-data.frame(subject=c(1,2),BW=c(0),OCC=c(0),Hb=c(0),WBC=c(0),n=c(0),D=c(0),tau=c(0),ts=c(0),c=c(0))
     ImaMSpar<-edit(ImaMSpar)
     ImaMSpar<-ymscheck(ImaMSpar)
     cat("\n")
     Ima.ms(length(ImaMSpar$subject),ImaMSpar$c,ImaMSpar$ts,ImaMSpar$tau,ImaMSpar$n,ImaMSpar$D,ImaMSpar$OCC,ImaMSpar$BW,ImaMSpar$Hb,ImaMSpar$WBC)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate output data information--               \n")
     cat("    cl_F = clerance/bioavailability (L/hr)                      \n")
     cat("    V_F = volume of distribution/bioavailability (L)            \n")
     cat("    Cm_pr = predicted measured conc.(mg/L)                      \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)         \n")
     cat("****************************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Imacpr(ImaMSpar$n,ImaMSpar$D,ImaMSpar$tau,ImaMSpar$ts)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Cm_pr (mg/L)")
     output1<-coutput
     show(coutput)
     C<-Imasscpr(ImaMSpar$D,ImaMSpar$tau)
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     output3<-coutput
     show(coutput)    
     cat("\n")
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Imams.pkoutput(ImaMSpar,output1,output3)
     cal.again()
  } 
   else if (pick == 4){
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    BW = body weight(kg)                                        \n")
     cat("    OCC = 0 for day 1 and 1 for day 29                          \n")
     cat("    Hb = Hemoglobin (g/dL)                                      \n")
     cat("    WBC = white blood count (10^9/L)                            \n")
     cat("    n = dosing number                                           \n") 
     cat("    D = dose for each dosing interval(mg)                       \n") 
     cat("    tau = dosing interval(hr)                                \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaMMpar<-data.frame(subject=c(1,2),BW=c(0),OCC=c(0),Hb=c(0),WBC=c(0),D=c(0),tau=c(0))
     ImaMMpar<-edit(ImaMMpar)
     ImaMMpar<-ymscheck(ImaMMpar)
     cat("\n")
     cat("****************************************************************\n")
     cat("    --Imatinib mesylate input data information--                \n")
     cat("    c = measured conc.(mg/L)                                    \n")
     cat("    ts = sampling time (hr)                                     \n")
     cat("****************************************************************\n\n")
     cat("\n")
     cat("****************************************************************\n")
     cat("      ATTENTION :                                               \n")
     cat("      Sampling Time (ts) must be greater than 1.5 hr.           \n")
     cat("****************************************************************\n")
     cat("\n\n")
     cat("          Pressing Enter to continue..                          \n")
     readline()
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     ImaMMMpar<-data.frame(subject=c(1),n=c(0),ts=c(0),conc=c(0))
     ImaMMMpar<-edit(ImaMMMpar)
     ImaMMMpar<-mscheck(ImaMMMpar)
     for(i in 1:length(unique(ImaMMpar$subject))){
     J=length(ImaMMMpar$ts[ImaMMMpar$subject==i])
     A=ImaMMMpar$conc[ImaMMMpar$subject==i]
     B=ImaMMMpar$ts[ImaMMMpar$subject==i]
     l=ImaMMpar$tau[ImaMMpar$subject==i]
     d=ImaMMMpar$n[ImaMMMpar$subject==i]
     e=ImaMMpar$D[ImaMMpar$subject==i]
     f=ImaMMpar$OCC[ImaMMpar$subject==i]
     g=ImaMMpar$BW[ImaMMpar$subject==i]
     h=ImaMMpar$Hb[ImaMMpar$subject==i]
     k=ImaMMpar$WBC[ImaMMpar$subject==i]
     Ima.mm(J,A,B,l,d,e,f,g,h,k,i)
     cat("\n")
     cat("**************************************************************************\n")
     cat("                       << Subject",i,">>                           \n\n" )
     cat("    --Imatinib mesylate output data information--        \n")
     cat("    cl_F = clerance/bioavailability (L/hr)               \n")
     cat("    V_F = volume of distribution/bioavailability (L)     \n")
     cat("    Ctss_pr = predicted steady-state trough conc.(mg/L)  \n\n")
     windows()
     samplesHistory("*",mfrow=c(3,1),ask=FALSE)
     windows()
     samplesDensity("*",mfrow=c(3,2),ask=FALSE)
     windows()
     samplesAutoC("*",1,mfrow=c(3,2),ask=FALSE)
     show(samplesStats("*"))
     cat("\n") 
     C<-Imasscpr(e,l)
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("Ctss_pr (mg/L)")
     show(coutput)    
     cat("\n")
     cat("\n**************************************************************************\n")
     }
     cal.again()
  }   
  else if (pick == 5){
     cat("\n\n") 
     run()
  }      
}


# warfarin data file 
War.model <- function()
{
  file.menu <- c("single subj with single conc",
                 "multiple subj with each single conc",
                 "Go back one upper level")
  pick <- menu(file.menu, title = "<< data type >>")
  if (pick == 1){
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Warfarin input data information--                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(day)                           \n")
     cat("    INR = international normalized ratio                 \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     WarSSpar<-data.frame(parameter=c("D (mg)","tau (day)","INR"),value=c(0))
     WarSSpar<-edit(WarSSpar)
     WarSSpar<-wcheck(WarSSpar)
     cat("\n")
     War.ss(WarSSpar[1,2],WarSSpar[2,2],WarSSpar[3,2])
     get(getOption("device"))()
     samplesHistory("*",mfrow=c(3,2), ask = FALSE)
     get(getOption("device"))()
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     get(getOption("device"))()
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("  --Warfarin output data information--                    \n")
     cat("  Cpmax = concentration related with maximum suppression  \n")
     cat("          of clotting factors (mg/L)                      \n")
     cat("  cl_F = clerance/bioavailability (L/day)                 \n")
     cat("  kc = first order rate constant for clotting factor      \n")
     cat("       degradation (1/day)                                \n")
     cat("  m = prothrombin complex activity remaining (%/day)      \n")
     cat("  v_F = volume of distribution/bioavailability (L)        \n")
     cat("  INR = predicted international normalized ratio          \n")
     cat("**********************************************************\n")    
     show(samplesStats("*"))
     cat("\n") 
     C<-Warcpr(WarSSpar[1,2],WarSSpar[2,2])
     sim<-matrix(C[1 ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("INR")
     show(coutput)
     cat("\n")   
     War.more(WarSSpar,coutput)
  } 
    else if (pick == 2){
     rm(list=ls(all=TRUE))
     cat("\n")
     cat("*********************************************************\n")
     cat("    --Warfarin input data information--                  \n")
     cat("    D = dose for each dosing interval(mg)                \n")
     cat("    tau = dosing interval(day)                           \n")
     cat("    INR = international normalized ratio                 \n")
     cat("*********************************************************\n\n")
     cat("\n")
     cat("     Please enter all parameters values at Data Editor          \n")
     cat("     window, and close Data Editor window by clicking           \n")
     cat("           (x) button at upper right corner.                    \n\n")
     WarMSpar<-data.frame(subject=c(1,2),D=c(0),tau=c(0),INR=c(0))
     WarMSpar<-edit(WarMSpar)
     WarMSpar<-wmscheck(WarMSpar)
     cat("\n")
     War.ms(length(WarMSpar$subject),WarMSpar$D,WarMSpar$tau,WarMSpar$INR)
     cat("\n\n")
     cat("**********************************************************\n")
     cat("   You can PgUp/PgDown to scroll through your checking    \n")
     cat("   convergence plots.                                     \n")  
     cat("**********************************************************\n\n")
     options("graphics.record"=TRUE)
     samplesHistory("*",mfrow=c(3,1), ask = FALSE)
     samplesDensity("*", mfrow = c(3, 2), ask = FALSE)
     samplesAutoC("*",1, mfrow = c(3, 2), ask = FALSE)
     cat("**********************************************************\n")
     cat("  --Warfarin output data information--                    \n")
     cat("  Cpmax = concentration related with maximum suppression  \n")
     cat("          of clotting factors (mg/L)                      \n")
     cat("  cl_F = clerance/bioavailability (L/day)                 \n")
     cat("  kc = first order rate constant for clotting factor      \n")
     cat("       degradation (1/day)                                \n")
     cat("  m = prothrombin complex activity remaining (%/day)      \n")
     cat("  v_F = volume of distribution/bioavailability (L)        \n")
     cat("  INR = predicted international normalized ratio          \n")
     cat("**********************************************************\n")    
     show(samplesStats("*"))
     cat("\n")
     C<-Warcpr(WarMSpar$D,WarMSpar$tau)  
     sim<-matrix(C[ ,1])
     coutput<-data.frame(sim)
     colnames(coutput)<-list("INR (mg/L)")
     show(coutput)  
     cat("\n") 
     cat("          Pressing Enter to show individual summary report                  \n")
     readline()
     Warms.pkoutput(WarMSpar,coutput)
     cal.again()
  } 
  else if (pick == 3){
     cat("\n\n") 
     run()
  }      
}
