ui = fluidPage(theme = teachingApps::add_theme(getShinyOption("theme")), 
               teachingApps::add_css(),

sidebarLayout(
  sidebarPanel(width = 3,
  hr(),
  sliderInput("range.nget", 
              label = "Range",
              min = 0, 
              max = 20, 
              value = c(0,4)),
  sliderInput("al.nget", 
              label = h2(HTML("&alpha;")),
              min =  0, 
              max =  3, 
              step = 0.5, 
              value = 1, 
              animate = TRUE),
  sliderInput("si.nget", 
              label = h2(HTML("&sigma;")),
              min = -5, 
              max =  5, 
              step = 0.5, 
              value = 0, 
              animate = TRUE),
  sliderInput("xi.nget", 
              label = h2(HTML("&xi;")),
              min = .5, 
              max = 10, 
              step = 0.5, 
              value = 1, 
              animate = TRUE)),

  mainPanel(width = 9,
 tabsetPanel(type = 'pills',
  tabPanel('Distribution Function',metricsgraphicsOutput("ngetC",height = "600px")),
  tabPanel('Density',              metricsgraphicsOutput("ngetP",height = "600px")),
  tabPanel('Survival',             metricsgraphicsOutput("ngetR",height = "600px")),
  tabPanel('Hazard',               metricsgraphicsOutput("ngeth",height = "600px")),
  tabPanel('Cumulative Hazard',    metricsgraphicsOutput("ngetH",height = "600px")),
  tabPanel('Quantile',             metricsgraphicsOutput("ngetQ",height = "600px"))
  ))))
