% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_pp_therapy.R
\name{template_therapy}
\alias{template_therapy}
\title{Template: Patient Profile Therapy Table and Plot}
\usage{
template_therapy(
  dataname = "ANL",
  atirel = "ATIREL",
  cmdecod = "CMDECOD",
  cmindc = "CMINDC",
  cmdose = "CMDOSE",
  cmtrt = "CMTRT",
  cmdosu = "CMDOSU",
  cmroute = "CMROUTE",
  cmdosfrq = "CMDOSFRQ",
  cmstdy = "CMSTDY",
  cmendy = "CMENDY",
  patient_id,
  font_size = 12L,
  ggplot2_args = teal.widgets::ggplot2_args()
)
}
\arguments{
\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{atirel}{(\code{character})\cr name of time relation of medication variable.}

\item{cmdecod}{(\code{character})\cr name of standardized medication name variable.}

\item{cmindc}{(\code{character})\cr name of indication variable.}

\item{cmdose}{(\code{character})\cr name of dose per administration variable.}

\item{cmtrt}{(\code{character})\cr name of reported name of drug, med, or therapy variable.}

\item{cmdosu}{(\code{character})\cr name of dose units variable.}

\item{cmroute}{(\code{character})\cr name of route of administration variable.}

\item{cmdosfrq}{(\code{character})\cr name of dosing frequency per interval variable.}

\item{cmstdy}{(\code{character})\cr name of study relative day of start of medication variable.}

\item{cmendy}{(\code{character})\cr name of study day of end of medication variable.}

\item{patient_id}{(\code{character})\cr patient ID.}

\item{font_size}{(\code{numeric})\cr font size value.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. The argument is merged with option \code{teal.ggplot2_args} and with default module arguments
(hard coded in the module body).
For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}
}
\value{
a \code{list} of expressions to generate a table or plot object.
}
\description{
Creates a valid expression to generate a patient profile therapy table and \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} plot using ADaM
datasets.
}
\seealso{
\code{\link[=tm_g_pp_therapy]{tm_g_pp_therapy()}}
}
\keyword{internal}
