% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yaml_utils.R
\name{as_yaml_auto}
\alias{as_yaml_auto}
\title{Parse a named list to \code{yaml} header for an \code{Rmd} file}
\usage{
as_yaml_auto(
  input_list,
  as_header = TRUE,
  convert_logi = TRUE,
  multi_output = FALSE,
  silent = FALSE
)
}
\arguments{
\item{input_list}{(\verb{named list}) non nested with slots names and their values compatible with \code{Rmd} \code{yaml} header.}

\item{as_header}{(\code{logical(1)}) optionally wrap with result with the internal \code{md_header()}, default \code{TRUE}.}

\item{convert_logi}{(\code{logical(1)}) convert a character values to logical,
if they are recognized as quoted \code{yaml} logical values , default \code{TRUE}.}

\item{multi_output}{(\code{logical(1)}) multi \code{output} slots in the \code{input} argument, default \code{FALSE}.}

\item{silent}{(\code{logical(1)}) suppress messages and warnings, default \code{FALSE}.}
}
\value{
\code{character} with \code{rmd_yaml_header} class,
result of \code{\link[yaml:as.yaml]{yaml::as.yaml}}, optionally wrapped with internal \code{md_header()}.
}
\description{
Converts a named list into a \code{yaml} header for \code{Rmd}, handling output types and arguments
as defined in the \code{rmarkdown} package. This function simplifies the process of generating \code{yaml} headers.
}
\details{
This function processes a non-nested (flat) named list into a \code{yaml} header for an \code{Rmd} document.
It supports all standard \code{Rmd} \code{yaml} header fields, including \code{author}, \code{date}, \code{title}, \code{subtitle},
\code{abstract}, \code{keywords}, \code{subject}, \code{description}, \code{category}, and \code{lang}.
Additionally,  it handles \code{output} field types and arguments as defined in the \code{rmarkdown} package.
}
\note{
Only non-nested lists are automatically parsed.
Nested lists require direct processing with \code{yaml::as.yaml}.
}
\examples{
# nested so using yaml::as.yaml directly
as_yaml_auto(
  list(author = "", output = list(pdf_document = list(toc = TRUE)))
)

# auto parsing for a flat list, like shiny input
input <- list(author = "", output = "pdf_document", toc = TRUE, keep_tex = TRUE)
as_yaml_auto(input)

as_yaml_auto(list(author = "", output = "pdf_document", toc = TRUE, keep_tex = "TRUE"))

as_yaml_auto(list(
  author = "", output = "pdf_document", toc = TRUE, keep_tex = TRUE,
  wrong = 2
))

as_yaml_auto(list(author = "", output = "pdf_document", toc = TRUE, keep_tex = 2),
  silent = TRUE
)

input <- list(author = "", output = "pdf_document", toc = TRUE, keep_tex = "True")
as_yaml_auto(input)
as_yaml_auto(input, convert_logi = TRUE, silent = TRUE)
as_yaml_auto(input, silent = TRUE)
as_yaml_auto(input, convert_logi = FALSE, silent = TRUE)

as_yaml_auto(
  list(
    author = "", output = "pdf_document",
    output = "html_document", toc = TRUE, keep_tex = TRUE
  ),
  multi_output = TRUE
)
as_yaml_auto(
  list(
    author = "", output = "pdf_document",
    output = "html_document", toc = "True", keep_tex = TRUE
  ),
  multi_output = TRUE
)
}
