% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validations.R
\name{validate_one_row_per_id}
\alias{validate_one_row_per_id}
\title{Validate that dataset has unique rows for key variables}
\usage{
validate_one_row_per_id(x, key = c("USUBJID", "STUDYID"))
}
\arguments{
\item{x}{(\code{data.frame})}

\item{key}{(\code{character}) Vector of ID variables from \code{x} that identify unique records.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\details{
This function is a wrapper for \code{shiny::validate}.
}
\examples{
iris$id <- rep(1:50, times = 3)
ui <- fluidPage(
  selectInput(
    inputId = "species",
    label = "Select species",
    choices = c("setosa", "versicolor", "virginica"),
    selected = "setosa",
    multiple = TRUE
  ),
  plotOutput("plot")
)
server <- function(input, output) {
  output$plot <- renderPlot({
    iris_f <- iris[iris$Species \%in\% input$species, ]
    validate_one_row_per_id(iris_f, key = c("id"))

    hist(iris_f$Sepal.Length, breaks = 5)
  })
}
if (interactive()) {
  shinyApp(ui, server)
}

}
