% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/connector_card.R
\docType{class}
\name{connector_card}
\alias{connector_card}
\title{Create a \code{connector_card} Structure With \code{teamr}}
\format{An \code{\link{R6Class}} generator object}
\usage{
# cc <- connector_card$new("https://outlook.office.com.....")
}
\description{
\code{connector_card} is at the very heart of the \code{teamr} package.
}
\details{
Assemble \code{connector_card} objects into a \code{connector_card}
structure and use the methods to append, modify or send your card to the webhook specified.
}
\section{Methods}{


\describe{
\item{\code{connector_card$new(hookurl, proxies, http_timeout)}}{Creates a new \code{connector_card}.}
\item{\code{text(mtext)}}{Change the \code{text} field of the card}
\item{\code{title(mtitle)}}{Change the \code{title} field of the card}
\item{\code{summary(msummary)}}{Change the \code{summary} field of the card.}
\item{\code{color(mcolor)}}{Change the default theme color.}
\item{\code{add_link_button(btext, burl)}}{Add button with links.}
\item{\code{newhook(nurl)}}{Change webhook address.}
\item{\code{print()}}{Print out the current hookurl and payload}
\item{\code{send()}}{Send \code{connector_card} to specified Microsoft Teams incomeing webhook URL.}
}
}

\section{Properties}{


\describe{
\item{\code{hookurl}}{Microsoft Teams incoming webhooks url.}
\item{\code{payload}}{R list of payloads(will be parsed into json)\link[httr]{POST}}
\item{\code{proxies}}{Proxy objects from \link[httr]{use_proxy}}
\item{\code{http_timeout}}{Timeout of the HTTP request. Default to 3 seconds.\link[httr]{timeout}}
}
}

\examples{
\dontrun{
library(teamr)

cc <- connector_card$new(hookurl = "https://outlook.office.com/webhook/...")
#' cc$text("Of on affixed civilly moments promise explain")
cc$title("This is a title")
cc$summary("This is a summary")
cc$add_link_button("This is the button Text", "https://github.com/wwwjk366/teamr")
cc$color("#008000")
cc$print()
cc$send()
}

}
\keyword{datasets}
