% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{circular_qqplot}
\alias{circular_qqplot}
\title{Quantile-Quantile Linearised Plot for Circular Distributions}
\usage{
circular_qqplot(
  x,
  axial = TRUE,
  xlab = paste("i/(n+1)"),
  ylab = NULL,
  main = "Circular Quantile-Quantile Plot",
  ...
)
}
\arguments{
\item{x}{numeric. Angles in degrees}

\item{axial}{Logical. Whether data are uniaxial (\code{axial=FALSE})}

\item{xlab, ylab, main}{plot labels.}

\item{...}{graphical parameters}
}
\value{
plot
}
\description{
Uniformly distributed orientations should yield a straight line through the
origin. Systematic departures from linearity will indicate preferred
orientation in some manner.
}
\examples{
x_vm <- rvm(100, mean = 0, kappa = 2)
circular_qqplot(x_vm, pch = 20)

x_norm <- rnorm(100, mean = 0, sd = 25)
circular_qqplot(x_norm, pch = 20)

x_unif <- runif(100, 0, 360)
circular_qqplot(x_unif, pch = 20)
}
\references{
Borradaile, G. J. (2003). Statistics of earth
science data: their distribution in time, space, and orientation (Vol. 351,
p. 329). Berlin: Springer.
}
