% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bot.R
\name{sendVideo}
\alias{sendVideo}
\title{sendVideo}
\usage{
sendVideo(chat_id, video, duration = NULL, caption = NULL,
  disable_notification = FALSE, reply_to_message_id = NULL,
  reply_markup = NULL, width = NULL, height = NULL,
  parse_mode = NULL, supports_streaming = NULL)
}
\arguments{
\item{chat_id}{Unique identifier for the target chat or username of
the target channel}

\item{video}{Video file to send. Pass a file_id as String to send a video that exists on
the Telegram servers (recommended), pass an HTTP URL as a String for Telegram to
get a video from the Internet, or upload a local video file by passing a file path}

\item{duration}{(Optional). Duration of sent audio in seconds}

\item{caption}{(Optional). Video caption, 0-1024 characters}

\item{disable_notification}{(Optional). Sends the message silently. Users will
receive a notification with no sound}

\item{reply_to_message_id}{(Optional). If the message is a reply, ID of the
original message}

\item{reply_markup}{(Optional). A Reply Markup parameter object, it can be either:
\itemize{
 \item{\code{\link{ReplyKeyboardMarkup}}}
 \item{\code{\link{InlineKeyboardMarkup}}}
 \item{\code{\link{ReplyKeyboardRemove}}}
 \item{\code{\link{ForceReply}}}}}

\item{width}{(Optional). Video width}

\item{height}{(Optional). Video height}

\item{parse_mode}{(Optional). Send 'Markdown' or 'HTML', if you want Telegram apps to show bold,
italic, fixed-width text or inline URLs in your bot's message}

\item{supports_streaming}{(Optional). Pass \code{TRUE}, if the uploaded video is
suitable for streaming}
}
\description{
Use this method to send video files, Telegram clients support mp4 videos
(other formats may be sent as Document).
}
\details{
You can also use it's snake_case equivalent \code{send_video}.
}
\examples{
\dontrun{
bot <- Bot(token = bot_token('RBot'))
chat_id <- user_id('me')
video_url <- "http://techslides.com/demos/sample-videos/small.mp4"

bot$sendVideo(chat_id = chat_id,
              video = video_url)
}
}
