% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary.R
\name{cli}
\alias{cli}
\alias{cli.character}
\alias{cli.numeric}
\alias{cli.t2d_geo}
\alias{cli.data.frame}
\alias{cli.t2d_cli}
\alias{print.t2d_cli}
\alias{[.t2d_cli}
\title{Boundary (*.cli) object}
\usage{
cli(x, fname, ...)

\method{cli}{character}(x, fname = NULL, ...)

\method{cli}{numeric}(x, fname = NULL, ...)

\method{cli}{t2d_geo}(x, fname = NULL, ...)

\method{cli}{data.frame}(x, fname = NULL, ...)

\method{cli}{t2d_cli}(x, fname = NULL, df = NULL, ...)

\method{print}{t2d_cli}(x, ..., n = 10)

\method{[}{t2d_cli}(x, ...)
}
\arguments{
\item{x}{Either: A \code{character} string providing the name of an existing boundary file;
a \code{numeric} vector of \code{ipobo} values (see \code{\link{geo}}) resulting
in  template boundary values (closed boundary with zero prescribed depths / velocities);
an object of class \code{t2d_geo} providing \code{ipobo} values converted into template boundary values;
a \code{data.frame} with required columns (see 'Value') giving the boundary parameters;
an object of class \code{t2d_cli}.}

\item{fname}{\code{character} string providing the name of the boundary file
that is to be generated (can also be used to replace an existing entry).}

\item{...}{Arguments passed to or from other methods.}

\item{df}{\code{data.frame} that can be given to update an existing object \code{x}.}

\item{n}{Maximum number of boundary points to print.}
}
\value{
An object of class \code{t2d_cli} consisting of an attribute \code{file}
pointing to a specific boundary file and a \code{data.frame} where each row
represents a point along the mesh boundary. Columns refer to:
\describe{
  \item{lihbor}{Depth conditions}
  \item{liubor}{Velocity conditions in u direction}
  \item{livbor}{Velocity conditions in v direction}
  \item{hbor}{Prescribed depth if lihbor = 5}
  \item{ubor}{Prescribed velocity if liubor = 6}
  \item{vbor}{Prescribed velocity if livbor = 6}
  \item{aubor}{Friction coefficient at boundary if liubor or livbor = 2}
  \item{litbor}{Tracer conditions}
  \item{tbor}{Prescribed value of tracer if litbor = 5}
  \item{atbor}{Coefficient of flow relation}
  \item{btbor}{Coefficient of flow relation}
  \item{n}{Global number of boundary point}
  \item{k}{Point number of boundary point numbering; can also represent a node colour}
}

See TELEMAC-2D user manual for more information.
}
\description{
Initialise a boundary (*.cli) object for use within TELEMAC.
}
