% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boundary.R
\name{read_cli}
\alias{read_cli}
\title{Read boundary (*.cli) file}
\usage{
read_cli(fname)
}
\arguments{
\item{fname}{\code{character} File name of the boundary file to be read.}
}
\value{
A \code{data.frame} where each row represents a point along the mesh boundary.
Columns refer to:
\describe{
  \item{lihbor}{Depth conditions}
  \item{liubor}{Velocity conditions in u direction}
  \item{livbor}{Velocity conditions in v direction}
  \item{hbor}{Prescribed depth if lihbor = 5}
  \item{ubor}{Prescribed velocity if liubor = 6}
  \item{vbor}{Prescribed velocity if livbor = 6}
  \item{aubor}{Friction coefficient at boundary if liubor or livbor = 2}
  \item{litbor}{Tracer conditions}
  \item{tbor}{Prescribed value of tracer if litbor = 5}
  \item{atbor}{Coefficient of flow relation}
  \item{btbor}{Coefficient of flow relation}
  \item{n}{Global number of boundary point}
  \item{k}{Point number of boundary point numbering; can also represent a node colour}
}

See TELEMAC-2D user manual for more information.
}
\description{
Reads the boundary file of a TELEMAC project.
}
