% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identifyMixture.R
\name{identifyMixture}
\alias{identifyMixture}
\title{Solve label switching and identify mixture.}
\usage{
identifyMixture(Func, Mu, Eta, S, centers)
}
\arguments{
\item{Func}{A numeric array of dimension \eqn{M \times d \times K}; data for clustering in the PPR.}

\item{Mu}{A numeric array of dimension \eqn{M \times r \times K}; draws of cluster means.}

\item{Eta}{A numeric array of dimension \eqn{M \times K}; draws of cluster sizes.}

\item{S}{A numeric matrix of dimension \eqn{M \times N}; draws of cluster assignments.}

\item{centers}{An integer or a numeric matrix of dimension \eqn{K \times d}; used to initialize \code{\link[stats:kmeans]{stats::kmeans()}}.}
}
\value{
A named list containing:
\itemize{
\item \code{"S"}: reordered assignments.
\item \code{"Mu"}: reordered Mu matrix.
\item \code{"Eta"}: reordered weights.
\item \code{"non_perm_rate"}: proportion of draws where the clustering did not
result in a permutation and hence no relabeling could be
performed; this is the proportion of draws discarded.
}
}
\description{
Clustering of the draws in the point process representation (PPR) using
\eqn{k}-means clustering.
}
\details{
The following steps are implemented:
\itemize{
\item A functional of the draws of the component-specific
parameters (\code{Func}) is passed to the function.  The functionals
of each component and iteration are stacked on top of each other in
order to obtain a matrix where each row corresponds to the
functional of one component.
\item The functionals are clustered into \eqn{K_+} clusters using \eqn{k}-means
clustering. For each functional a group label is obtained.
\item The obtained labels of the functionals are used to construct
a classification for each MCMC iteration.  Those classifications
which are a permutation of \eqn{(1,\ldots,K_+)} are used to reorder
the Mu and Eta draws and the assignment matrix S. This results in an
identified mixture model.
\item Note that only iterations resulting in permutations
are used for parameter estimation and deriving the final
partition. Those MCMC iterations where the obtained
classifications of the functionals are not a permutation of
\eqn{(1,\ldots,K_+)} are discarded as no unique assignment of functionals
to components can be made.  If the non-permutation rate, i.e. the
proportion of MCMC iterations where the obtained classifications
of the functionals are not a permutation, is high, this is an
indication of a poor clustering solution, as the
functionals are not clearly separated.
}
}
