% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{get.significance}
\alias{get.significance}
\title{TDS significance proportion}
\usage{
get.significance(chance, n, alpha = 0.05)
}
\arguments{
\item{chance}{chance proportion; see \code{\link[tempR]{get.chance}}.}

\item{n}{number of observations.}

\item{alpha}{significance level for binomial test of 2 independent proportions (based on normal approximation; see: Pineau et al., 2009, Eq. 1)}
}
\description{
Obtains the TDS significance proportion based on the number of observations and chance, as proposed by Pineau et al. (2009; Eq. 1).
}
\details{
The TDS significance level proposed by Pineau et al. (2009, Eq. 1) provides a simple and widely used heuristic approach for contextualizing observed dominance rates, but should not be used for statistical inference.
}
\examples{
# example using 'bars' data set
attributes <- unique(bars$attribute)
chance <- get.chance(attributes)
signif <- get.significance(chance, nrow(unique(bars[, 1:2])))
signif
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal Dominance of Sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

