% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tds.R
\encoding{UTF-8}
\name{get.dominance.rates}
\alias{get.dominance.rates}
\title{Get TDS dominance rates}
\usage{
get.dominance.rates(citations, n)
}
\arguments{
\item{citations}{matrix of dominance counts}

\item{n}{number of observations (evaluations) per cell}
}
\description{
Get TDS dominance rates.
}
\examples{
x <- rbind(c( 6,  6,  8, 14, 16, 22, 22, 21, 13, 11, 14,  7,  7,  6,  5,  3),
           c(14, 24, 31, 36, 37, 39, 44, 48, 51, 55, 48, 40, 30, 20, 10,  5),
           c( 7,  8,  9, 15, 17, 21, 21, 20, 21, 22, 18, 17, 17, 20, 20, 20),
           c(44, 23, 23, 26,  1,  2,  2,  2,  2,  3,  4,  7, 15, 14, 18, 22),
           c(20, 30, 20,  0, 20,  7,  2,  0,  4,  0,  7, 20, 22, 31, 38, 41))
colnames(x) <- 0:15
get.dominance.rates(x, n = 91)
}
\references{
Pineau, N., Schlich, P., Cordelle, S., Mathonnière, C., Issanchou, S., Imbert, A., Rogeaux, M., Etiévant, P., & Köster, E. (2009). Temporal Dominance of Sensations: Construction of the TDS curves and comparison with time–intensity.  \emph{Food Quality and Preference}, 20, 450–455. \url{http://dx.doi.org/10.1016/j.foodqual.2009.04.005}
}

