% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{loglik_kappa_est}
\alias{loglik_kappa_est}
\title{Kappa log-likelihood}
\usage{
loglik_kappa_est(par, delta, D_diag, mesh, C1 = 1/(4 * pi), Q = NULL)
}
\arguments{
\item{par}{Vector of length two containing values of log kappa and log residual variance at which to compute log likelihood}

\item{delta}{Estimate of delta (subject effect or deviation)}

\item{D_diag}{Diagonal values of D matrix (template standard deviations)}

\item{mesh}{Object of class "templateICA_mesh" containing the triangular mesh (see \code{\link{make_mesh}})}

\item{C1}{For the unit variance case, \eqn{\tau^2 = C1/\kappa^2}, where \eqn{C1 = 1/(4\pi)} when \eqn{\alpha=2}, \eqn{\nu=1}, \eqn{d=2}}

\item{Q}{Equal to the number of ICs for the common smoothness model, or NULL for the IC-specific smoothness model}
}
\value{
Value of negative log likelihood
}
\description{
Applicable to a single latent field, or multiple latent fields if common smoothness is assumed
}
\details{
Compute log-likelihood of kappa given an initial estimate of delta
}
\keyword{internal}
