% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as-term.R
\name{as_term}
\alias{as_term}
\alias{as.term}
\alias{as_term.character}
\alias{as_term.numeric}
\title{Coerce to a Term Vector}
\usage{
as_term(x, ...)

as.term(x, ...)

\method{as_term}{character}(x, repair = FALSE, normalize = repair, ...)

\method{as_term}{numeric}(x, name = "par", ...)
}
\arguments{
\item{x}{The object.}

\item{...}{Unused.}

\item{repair}{A flag specifying whether to repair terms.}

\item{normalize}{A flag specifying whether to normalize terms.}

\item{name}{A string specifying the name of the parameter.}
}
\description{
Coerces an R object to a \code{\link[=term-vector]{term-vector()}}.
}
\details{
\code{as.term} has been \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}} for \code{as_term}.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: Coerce character vector to term vector

\item \code{numeric}: Coerce numeric object to term vector
}}

\examples{
as_term(matrix(1:4, 2))
as_term(c("parm3[10]", "parm3[2]", "parm[2,2]", "parm[1,1]"))
}
\seealso{
\code{\link[=term-vector]{term-vector()}} and \code{\link[=repair_terms]{repair_terms()}}
}
