% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting_functions.R
\name{format_xx}
\alias{format_xx}
\title{Formatting: XX as Formatting Function}
\usage{
format_xx(str)
}
\arguments{
\item{str}{(\code{string})\cr template.}
}
\value{
An \code{rtables} formatting function.
}
\description{
Translate a string where x and dots are interpreted as number place
holders, and others as formatting elements.
}
\examples{
test <- list(c(1.658, 0.5761), c(1e1, 785.6))

z <- format_xx("xx (xx.x)")
sapply(test, z)

z <- format_xx("xx.x - xx.x")
sapply(test, z)

z <- format_xx("xx.x, incl. xx.x\% NE")
sapply(test, z)

}
\seealso{
Other formatting functions: 
\code{\link{extreme_format}},
\code{\link{format_count_fraction_fixed_dp}()},
\code{\link{format_count_fraction}()},
\code{\link{format_extreme_values_ci}()},
\code{\link{format_extreme_values}()},
\code{\link{format_fraction_fixed_dp}()},
\code{\link{format_fraction_threshold}()},
\code{\link{format_fraction}()},
\code{\link{formatting_functions}}
}
\concept{formatting functions}
