% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic_regression.R
\name{summarize_logistic}
\alias{summarize_logistic}
\title{Multivariate Logistic Regression Table}
\usage{
summarize_logistic(
  lyt,
  conf_level,
  drop_and_remove_str = "",
  .indent_mods = NULL
)
}
\arguments{
\item{lyt}{(\code{layout})\cr input layout where analyses will be added to.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{drop_and_remove_str}{(\code{character})\cr string to be dropped and removed.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels. Defaults to 0, which corresponds to the
unmodified default behavior. Can be negative.}
}
\value{
A layout object suitable for passing to further layouting functions, or to \code{\link[rtables:build_table]{rtables::build_table()}}.
Adding this function to an \code{rtable} layout will add a logistic regression variable summary to the table layout.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Layout-creating function which summarizes a logistic variable regression for binary outcome with
categorical/continuous covariates in model statement. For each covariate category (if categorical)
or specified values (if continuous), present degrees of freedom, regression parameter estimate and
standard error (SE) relative to reference group or category. Report odds ratios for each covariate
category or specified values and corresponding Wald confidence intervals as default but allow user
to specify other confidence levels. Report p-value for Wald chi-square test of the null hypothesis
that covariate has no effect on response in model containing all specified covariates.
Allow option to include one two-way interaction and present similar output for
each interaction degree of freedom.
}
\note{
For the formula, the variable names need to be standard \code{data.frame} column names without
special characters.
}
\examples{
library(dplyr)
library(broom)

adrs_f <- tern_ex_adrs \%>\%
  filter(PARAMCD == "BESRSPI") \%>\%
  filter(RACE \%in\% c("ASIAN", "WHITE", "BLACK OR AFRICAN AMERICAN")) \%>\%
  mutate(
    Response = case_when(AVALC \%in\% c("PR", "CR") ~ 1, TRUE ~ 0),
    RACE = factor(RACE),
    SEX = factor(SEX)
  )
formatters::var_labels(adrs_f) <- c(formatters::var_labels(tern_ex_adrs), Response = "Response")
mod1 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE")
  )
)
mod2 <- fit_logistic(
  data = adrs_f,
  variables = list(
    response = "Response",
    arm = "ARMCD",
    covariates = c("AGE", "RACE"),
    interaction = "AGE"
  )
)

df <- tidy(mod1, conf_level = 0.99)
df2 <- tidy(mod2, conf_level = 0.99)

# flagging empty strings with "_"
df <- df_explicit_na(df, na_level = "_")
df2 <- df_explicit_na(df2, na_level = "_")

result1 <- basic_table() \%>\%
  summarize_logistic(
    conf_level = 0.95,
    drop_and_remove_str = "_"
  ) \%>\%
  build_table(df = df)
result1

result2 <- basic_table() \%>\%
  summarize_logistic(
    conf_level = 0.95,
    drop_and_remove_str = "_"
  ) \%>\%
  build_table(df = df2)
result2

}
