% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kaplan_meier_plot.R
\name{h_grob_y_annot}
\alias{h_grob_y_annot}
\title{Helper: Grid Object with y-axis Annotation}
\usage{
h_grob_y_annot(ylab, yaxis)
}
\arguments{
\item{ylab}{(\code{gtable})\cr the y-lab as a graphical object derived from a \code{ggplot}.}

\item{yaxis}{(\code{gtable})\cr the y-axis as a graphical object derived from a \code{ggplot}.}
}
\value{
a \code{gTree} object containing the y-axis annotation from a \code{ggplot}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Build the y-axis annotation from a decomposed \code{ggplot}.
}
\examples{
\donttest{
library(dplyr)
library(survival)
library(grid)

fit_km <- tern_ex_adtte \%>\%
  filter(PARAMCD == "OS") \%>\%
  survfit(form = Surv(AVAL, 1 - CNSR) ~ ARMCD, data = .)
data_plot <- h_data_plot(fit_km = fit_km)
xticks <- h_xticks(data = data_plot)
gg <- h_ggkm(
  data = data_plot,
  censor_show = TRUE,
  xticks = xticks, xlab = "Days", ylab = "Survival Probability",
  title = "title", footnotes = "footnotes", yval = "Survival"
)

g_el <- h_decompose_gg(gg)

grid::grid.newpage()
pvp <- grid::plotViewport(margins = c(5, 4, 2, 20))
pushViewport(pvp)
grid::grid.draw(h_grob_y_annot(ylab = g_el$ylab, yaxis = g_el$yaxis))
grid.rect(gp = grid::gpar(lty = 1, col = "gray35", fill = NA))
}

}
