% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/control_survival.R
\name{control_surv_timepoint}
\alias{control_surv_timepoint}
\title{Control function for \code{survfit} models for patients' survival rate at time points}
\usage{
control_surv_timepoint(
  conf_level = 0.95,
  conf_type = c("plain", "log", "log-log")
)
}
\arguments{
\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{conf_type}{(\code{string})\cr confidence interval type. Options are "plain" (default), "log", "log-log",
see more in \code{\link[survival:survfit]{survival::survfit()}}. Note option "none" is no longer supported.}
}
\value{
A list of components with the same names as the arguments.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

This is an auxiliary function for controlling arguments for \code{survfit} model, typically used internally to specify
details of \code{survfit} model for \code{\link[=s_surv_timepoint]{s_surv_timepoint()}}. \code{conf_level} refers to patient risk estimation at a time point.
}
