% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_spatial_rgb.R
\docType{data}
\name{geom_spatial_rgb}
\alias{geom_spatial_rgb}
\alias{StatSpatialRGB}
\alias{stat_spatial_rgb}
\title{Plot RGB rasters in ggplot2}
\usage{
geom_spatial_rgb(
  mapping = NULL,
  data = NULL,
  stat = "spatialRGB",
  position = "identity",
  ...,
  hjust = 0.5,
  vjust = 0.5,
  interpolate = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  scale = NULL
)

stat_spatial_rgb(
  mapping = NULL,
  data = NULL,
  geom = "raster",
  position = "identity",
  na.rm = FALSE,
  show.legend = FALSE,
  inherit.aes = TRUE,
  scale = NULL,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. In addition to the three
options described in [ggplot2::geom_raster], there are two additional
methods:

If a `RasterStack` object (see [raster::stack]), this function will coerce
the stack to a data frame and assume the raster bands are in RGB order
(while allowing for, but ignoring, a fourth alpha band).

If a length-1 character vector, this function will attempt to load the object
via [raster::stack].}

\item{stat}{The statistical transformation to use on the data for this
layer, as a string.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{hjust}{horizontal and vertical justification of the grob.  Each
justification value should be a number between 0 and 1.  Defaults to 0.5
for both, centering each pixel over its data location.}

\item{vjust}{horizontal and vertical justification of the grob.  Each
justification value should be a number between 0 and 1.  Defaults to 0.5
for both, centering each pixel over its data location.}

\item{interpolate}{If \code{TRUE} interpolate linearly, if \code{FALSE}
(the default) don't interpolate.}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{scale}{Integer. Maximum (possible) value in the three channels.
If `NULL`, attempts to infer proper values from data -- if all RGB values
are <= 1 then 1, <= 255 then 255, and otherwise 65535.}

\item{geom}{The geometric object to use display the data}
}
\description{
`geom_spatial_rgb` and `stat_spatial_rgb` allow users to plot three-band RGB
rasters in [ggplot2], using these layers as background base maps for other
spatial plotting. Note that unlike [ggplot2::geom_sf], this function does
_not_ force [ggplot2::coord_sf]; for accurate mapping, add
[ggplot2::coord_sf] with a `crs` value matching your input raster as a layer.
}
\examples{
\dontrun{

simulated_data <- data.frame(
  id = seq(1, 100, 1),
  lat = runif(100, 44.04905, 44.17609),
  lng = runif(100, -74.01188, -73.83493)
)

simulated_data <- sf::st_as_sf(simulated_data, coords = c("lng", "lat"))
simulated_data <- sf::st_set_crs(simulated_data, 4326)

output_tiles <- get_tiles(simulated_data,
  services = c("ortho"),
  resolution = 120
)

merged_ortho <- tempfile(fileext = ".tif")
merge_rasters(output_tiles[["ortho"]], merged_ortho)

merged_stack <- raster::stack(merged_ortho)

library(ggplot2)

ggplot() +
  geom_spatial_rgb(
    data = merged_ortho,
    mapping = aes(
      x = x,
      y = y,
      r = red,
      g = green,
      b = blue
    )
  ) +
  geom_sf(data = simulated_data) +
  coord_sf(crs = 4326)

ggplot() +
  geom_spatial_rgb(
    data = merged_stack,
    mapping = aes(
      x = x,
      y = y,
      r = red,
      g = green,
      b = blue
    )
  ) +
  geom_sf(data = simulated_data) +
  coord_sf(crs = 4326)
}

}
\seealso{
Other visualization functions: 
\code{\link{combine_overlays}()},
\code{\link{raster_to_raw_tiles}()},
\code{\link{vector_to_overlay}()}
}
\concept{visualization functions}
\keyword{datasets}
