% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expectation.R
\name{expect_custom}
\alias{expect_custom}
\title{Extension of 'expect' to allow inclusion of custom fields}
\usage{
expect_custom(
  ok,
  failure_message,
  info = NULL,
  srcref = NULL,
  trace = NULL,
  ...
)
}
\arguments{
\item{ok}{\code{TRUE} or \code{FALSE} indicating if the expectation was successful.}

\item{failure_message}{Message to show if the expectation failed.}

\item{info}{Character vector continuing additional information. Included for
backward compatibility only and new expectations should not use it.}

\item{srcref}{Location of the failure. Should only needed to be explicitly
supplied when you need to forward a srcref captured elsewhere.}

\item{...}{Additional data to be added to a list in the \code{custom} attribute of
the resulting expectation.}
}
\value{
An expectation object. Signals the expectation condition with a
\code{continue_test} restart.
}
\description{
Use expect_custom to allow inclusion of arbitrary data in expectation
results. Additional data is stored in a list in an attribute called \code{custom}
in the resulting expectation. This allows data expectations to store
information about the number of failed and successful cases for reporting of
test results.
}
\examples{
# calling expect_custom directly with some custom data
x <- expect_custom(TRUE, "Test", extra_data = 1:5, more_data = "Hello")
str(x)

# an example expectation (note additional libraries used)
library(rlang)

expect_example <- function(var, data = get_testdata()) {
  act <- quasi_label(enquo(data))
  act$var_desc <- expr_label(get_expr(enquo(var)))
  act$var <- expr_text(get_expr(enquo(var)))

  act$result <- act$val[[act$var]] > 0
  act$result[is.na(act$result)] <- FALSE

  expect_custom(
    all(act$result, na.rm = TRUE),
    glue::glue("{act$lab} has {sum(!act$result, na.rm = TRUE)} cases with \\\\
                {act$var_desc} not greater than 0."),
    failed_count = sum(!act$result, na.rm = TRUE),
    total_count = sum(!is.na(act$result))
  )

  invisible(act$result)
}

try(expect_example(x, data = data.frame(x = c(NA, -2:2))))
}
\keyword{internal}
