% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_skeleton.R
\name{test_skeleton}
\alias{test_skeleton}
\title{Create a test skeleton file for the currently open .R file}
\usage{
test_skeleton(fname = NULL, open = TRUE,
  sep = options("testthis.sep"))
}
\arguments{
\item{fname}{\code{character} scalar. Target R script file to open. If empty the file
currently open in the editor will be used.}

\item{open}{\code{logical} scalar. Should the test file be opened after it is created?}

\item{sep}{\code{character} scalar. Separator between \file{test} and \file{fname}
when constructing the test file name. Should either be \code{"_"} or \code{"-"} for
compatibility with testthat.}
}
\value{
\code{NULL} (invisibly)
}
\description{
If the file currently open in the RStudio editor is called \code{my_function.R},
this creates the file \file{/tests/testthat/test_my_function.R} and fills it
with a basic test skeleton.
}
\section{Side effects}{

Creates an R script file in the file system.
}

\seealso{
\code{\link[usethis:use_test]{usethis::use_test()}}
}
