% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,glmmadmb-method}
\alias{extract,glmmadmb-method}
\alias{extract.glmmadmb}
\title{\code{\link{extract}} method for \code{glmmadmb} objects}
\usage{
\S4method{extract}{glmmadmb}(
  model,
  include.variance = TRUE,
  include.dispersion = TRUE,
  include.zero = TRUE,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.nobs = TRUE,
  include.groups = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{include.variance}{Report group variances?}

\item{include.dispersion}{Report the dispersion parameter?}

\item{include.zero}{Should the binary part of a zero-inflated regression
model or hurdle model be included in the coefficients block (after the
count model)?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF
block?}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?}

\item{include.groups}{Report the number of groups?}

\item{...}{Custom parameters, which are handed over to subroutines. Currently
not in use.}
}
\description{
\code{\link{extract}} method for \code{glmmadmb} objects created by the
\code{glmmadmb} function in the \pkg{glmmADMB} package.
}
