% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{extract,selection-method}
\alias{extract,selection-method}
\alias{extract.selection}
\title{\code{\link{extract}} method for \code{selection} objects}
\usage{
\S4method{extract}{selection}(
  model,
  prefix = TRUE,
  include.selection = TRUE,
  include.outcome = TRUE,
  include.errors = TRUE,
  include.aic = TRUE,
  include.bic = TRUE,
  include.loglik = TRUE,
  include.rsquared = TRUE,
  include.adjrs = TRUE,
  include.nobs = TRUE,
  ...
)
}
\arguments{
\item{model}{A statistical model object.}

\item{prefix}{Include prefix before the label of the coefficient in order to
identify the current model component?}

\item{include.selection}{Report the selection component of a sample selection
model?}

\item{include.outcome}{Report the outcome component of a sample selection
model?}

\item{include.errors}{Report the error terms of a sample selection model?}

\item{include.aic}{Report Akaike's Information Criterion (AIC) in the GOF}

\item{include.bic}{Report the Bayesian Information Criterion (BIC) in the GOF
block?}

\item{include.loglik}{Report the log likelihood in the GOF block?}

\item{include.rsquared}{Report R^2 in the GOF block?}

\item{include.adjrs}{Report adjusted R^2 in the GOF block?}

\item{include.nobs}{Report the number of observations in the GOF block?
block?}

\item{...}{Custom parameters, which are handed over to subroutines, in this
case to the \code{summary} method for the object.}
}
\description{
\code{\link{extract}} method for \code{selection} objects created by the
\code{selection} function in the \pkg{sampleSelection} package.
}
