% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_hasher.R
\name{feature_hasher}
\alias{feature_hasher}
\title{Creates meta information about feature hashing}
\usage{
feature_hasher(hash_size = 2^18, ngram = c(ngram_min = 1L, ngram_max = 1L),
  signed_hash = FALSE)
}
\arguments{
\item{hash_size}{\code{integer} > 0 - number of hash-buckets
for hashing trick (feature hashing). Preferably power of 2 number.}

\item{ngram}{\code{integer} vector. The lower and upper boundary of the range of
n-values for different n-grams to be extracted. All values of n such that}

\item{signed_hash}{\code{logical},  indicating whether to use second hash-function
to reduce impact of collisions.}
}
\description{
Creates \code{text2vec_feature_hasher} object (actually a simple list),
which contains meta-information about feature hashing parameters. Usually result
of this function is used in \link{create_hash_corpus} function.
}
\examples{
fh <- feature_hasher(2**16, c(1L, 2L), TRUE)
}
\seealso{
\link{create_hash_corpus}
}

