% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabulary.R
\name{create_vocabulary}
\alias{create_vocabulary}
\alias{create_vocabulary.character}
\alias{create_vocabulary.itoken}
\alias{create_vocabulary.list}
\alias{vocabulary}
\title{Creates a vocabulary of unique terms}
\usage{
create_vocabulary(itoken_src, ngram = c(ngram_min = 1L, ngram_max = 1L),
  stopwords = character(0))

vocabulary(itoken_src, ngram = c(ngram_min = 1L, ngram_max = 1L),
  stopwords = character(0))

\method{create_vocabulary}{character}(itoken_src, ngram = c(ngram_min = 1L,
  ngram_max = 1L), stopwords = character(0))

\method{create_vocabulary}{itoken}(itoken_src, ngram = c(ngram_min = 1L,
  ngram_max = 1L), stopwords = character(0))

\method{create_vocabulary}{list}(itoken_src, ngram = c(ngram_min = 1L,
  ngram_max = 1L), stopwords = character(0), ...)
}
\arguments{
\item{itoken_src}{iterator over a \code{list} of \code{character} vectors,
which are the documents from which the user wants to construct a vocabulary.
Alternatively, a \code{character} vector of user-defined vocabulary terms
(which will be used "as is").}

\item{ngram}{\code{integer} vector. The lower and upper boundary of the range
of n-values for different n-grams to be extracted. All values of \code{n}
such that ngram_min <= n <= ngram_max will be used.}

\item{stopwords}{\code{character} vector of stopwords to filter out}

\item{...}{additional arguments to \link{foreach} function.}
}
\value{
\code{text2vec_vocabulary} object, which is actually a \code{list}
 with following fields:

 1. \code{vocab}: a \code{data.frame} which contains columns \itemize{
 \item{\code{terms}       }{ \code{character} vector of unique terms}
 \item{\code{terms_counts} }{ \code{integer} vector of term counts across all
 documents} \item{\code{doc_counts}  }{ \code{integer} vector of document
 counts that contain corresponding term} }

 2. \code{ngram}: \code{integer} vector, the lower and upper boundary of the
 range of n-gram-values.

 3. \code{document_count}: \code{integer} number of documents vocabulary was
 built.
}
\description{
This function collects unique terms and corresponding statistics.
 See the below for details.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: creates \code{text2vec_vocabulary} from predefined
character vector. Terms will be inserted \bold{as is}, without any checks
(ngrams numner, ngram delimiters, etc.).

\item \code{itoken}: collects unique terms and corresponding statistics from object.

\item \code{list}: collects unique terms and corresponding
statistics from list of itoken iterators. If parallel backend is
registered, it will build vocabulary in parallel using \link{foreach}.
}}
\examples{
data("movie_review")
txt <- movie_review[['review']][1:100]
it <- itoken(txt, tolower, word_tokenizer, chunks_number = 10)
vocab <- create_vocabulary(it)
pruned_vocab = prune_vocabulary(vocab, term_count_min = 10,
 doc_proportion_max = 0.8, doc_proportion_min = 0.001, max_number_of_terms = 20000)
}

