% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter_element.R
\name{filter_element}
\alias{filter_element}
\title{Remove Elements in a Vetor}
\usage{
filter_element(x, pattern, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{A regex pattern to match for exclusion.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grep}}.}
}
\value{
Returns a vector with matching elements removed.
}
\description{
Removes the matching elements of a vector.
}
\examples{
x <- c('dog', 'cat', 'bat', 'dingo', 'dragon', 'dino')
filter_element(x, '^d.+?g')
filter_element(x, 'at$')
filter_element(x, '^d')
filter_element(x, '\\\\b(dog|cat)\\\\b')
}
