% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_holder.R
\name{sub_holder}
\alias{sub_holder}
\title{Hold the Place of Characters Prior to Subbing}
\usage{
sub_holder(x, pattern, alpha.type = TRUE, ...)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{Character string to be matched in the given character vector.}

\item{alpha.type}{logical.  If \code{TRUE} alpha (lower case letters) are 
used for the key.  If \code{FALSE} numbers are used as the key.}

\item{\dots}{Additional arguments passed to \code{\link[base]{gsub}}.}
}
\value{
Returns a list with the following:
\item{output}{keyed place holder character vector} 
\item{unhold}{A function used to revert back to the original values}
}
\description{
This function holds the place for particular character values, allowing the 
user to manipulate the vector and then revert the place holders back to the 
original values.
}
\note{
The \code{unhold} function for \code{sub_holder} will only work on keys
that have not been disturbed by subsequent alterations.  The key follows the 
pattern of `zzzplaceholder` followed by lower case letter keys followed by
`zzz`.
}
\examples{
## `alpha.type` as TRUE
library(lexicon); library(textshape)
(fake_dat <- paste(hash_emoticons[1:11, 1, with=FALSE][[1]], DATA$state))
(m <- sub_holder(fake_dat, hash_emoticons[[1]]))
m$unhold(strip(m$output))

## `alpha.type` as FALSE (numeric keys)
vowels <- LETTERS[c(1, 5, 9, 15, 21)]
(m2 <- sub_holder(toupper(DATA$state), vowels, alpha.type = FALSE))
m2$unhold(gsub("[^0-9]", "", m2$output))
mtabulate(strsplit(m2$unhold(gsub("[^0-9]", "", m2$output)), ""))
}
