% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sample.fragments}
\alias{sample.fragments}
\title{Sample fragments of text to contextualize a phrase.}
\usage{
sample.fragments(phrases, labeling, corp, N = 10, char.before = 80,
  char.after = char.before, metainfo = NULL)
}
\arguments{
\item{phrases}{Phrases to examine (a list of strings)}

\item{labeling}{-- a vector of the same length as the corpus}

\item{corp}{Corpus object (tm package Corpus object)}

\item{N}{size of sample to make.}

\item{char.before}{Number of characters of document to pull before phrase to give
context.}

\item{char.after}{As above, but trailing characters.  Defaults to char.before value.}

\item{metainfo}{-- extra string to add to the printout for clarity if many such
printouts are being generated.}
}
\description{
Take a phrase, a labeling and a corpus and return text fragments
containing that phrase.

Grab all phrases and then give sample of N from positive class
and N from negative class.  Sampling is to first sample from documents
and then sample a random phrase from each of those documents.
}
\examples{
library( tm )
data( bathtub )
sample.fragments( "bathtub", meta(bathtub)$meth.chl, bathtub )
}
\seealso{
Other sample.fragments: \code{\link{fragment.sample}},
  \code{\link{is.fragment.sample}};
  \code{\link{print.fragment.sample}}
}

