% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/text_searching.R
\name{make.phrase.matrix}
\alias{make.phrase.matrix}
\title{Make a table of where phrases appear in a corpus}
\usage{
make.phrase.matrix(phrase_list, corpus)
}
\arguments{
\item{phrase_list}{List of strings}

\item{corpus}{A corpus object from tm package}
}
\value{
a n X p matrix, n being number of documents, p being number of phrases.
}
\description{
Generate a n by p phrase count matrix, with n being number of documents
and p being number of phrases:
 \\tabular{rrrrr}{
  0 \\tab 0 \\tab 0 \\tab 0 \\tab 0 \\cr
  1 \\tab 6 \\tab 2 \\tab 0 \\tab 0 \\cr
  8 \\tab 0 \\tab 0 \\tab 0 \\tab 0}
This is the phrase equivilent of a document-term matrix.
}
\examples{
library( tm )
data( bathtub )
lbl = meta( bathtub )$meth.chl
head( make.phrase.matrix( c("bathtub","strip+", "vapor *"), bathtub ) )
}
\seealso{
Other textregCounting: \code{\link{make.count.table}};
  \code{\link{phrase.count}}
}

