% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grab_match.R
\name{grab_match}
\alias{grab_match}
\alias{grab_match.character}
\alias{grab_match.list}
\alias{grab_match.data.frame}
\title{Get Elements Matching Between 2 Points}
\usage{
grab_match(x, from = NULL, to = NULL, from.n = 1, to.n = 1, ...)

\method{grab_match}{character}(x, from = NULL, to = NULL, from.n = 1, to.n = 1, ...)

\method{grab_match}{list}(x, from = NULL, to = NULL, from.n = 1, to.n = 1, ...)

\method{grab_match}{data.frame}(
  x,
  from = NULL,
  to = NULL,
  from.n = 1,
  to.n = 1,
  text.var = TRUE,
  ...
)
}
\arguments{
\item{x}{A character vector, \code{\link[base]{data.frame}}, or list.}

\item{from}{A regex to start getting from (if \code{NULL} defaults to the 
first element/row).}

\item{to}{A regex to get up to (if \code{NULL} defaults to the last element/row).}

\item{from.n}{If more than one element matches \code{from} this dictates 
which one should be used.  Must be an integer up to the number of possible
matches, \code{'first'} (equal to \code{1}), \code{'last'} (the last match
possible), or \code{'n'} (the same as \code{'last'}).}

\item{to.n}{If more than one element matches \code{to} this dictates 
which one should be used.  Must be an integer up to the number of possible
matches, \code{'first'} (equal to \code{1}), \code{'last'} (the last match
possible), or \code{'n'} (the same as \code{'last'}).}

\item{text.var}{The name of the text variable with matches. If \code{TRUE}
\code{grab_match} tries to detect the text column.}

\item{\ldots}{Other arguments passed to \code{\link[base]{grep}}, most notable
is \code{ignore.case}.}
}
\value{
Returns a subset of the original data set.
}
\description{
Use regexes to get all the elements between two points.
}
\examples{
grab_match(DATA$state, from = 'dumb', to = 'liar')
grab_match(DATA$state, from = 'dumb')
grab_match(DATA$state, to = 'liar')
grab_match(DATA$state, from = 'no', to = 'the', ignore.case = TRUE)
grab_match(DATA$state, from = 'no', to = 'the', ignore.case = TRUE, 
    from.n = 'first', to.n = 'last')
grab_match(as.list(DATA$state), from = 'dumb', to = 'liar')

## Data.frame: attempts to find text.var
grab_match(DATA, from = 'dumb', to = 'liar')
}
