% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert.R
\name{as.data.frame.tf}
\alias{as.data.frame.tf}
\alias{as.matrix.tf}
\alias{as.function.tf}
\title{Convert functional data back to tabular data formats}
\usage{
\method{as.data.frame}{tf}(x, row.names = NULL, optional = FALSE, unnest = FALSE, ...)

\method{as.matrix}{tf}(x, arg, interpolate = FALSE, ...)

\method{as.function}{tf}(x, ...)
}
\arguments{
\item{x}{a \code{tf} object}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{not used}

\item{unnest}{if \code{TRUE}, the function will return a data.frame with the
evaluated functions.}

\item{...}{additional arguments to be passed to or from methods.}

\item{arg}{a vector of argument values / evaluation points for \code{x}. Defaults
to \code{tf_arg(x)}.}

\item{interpolate}{should functions be evaluated (i.e., inter-/extrapolated)
for values in \code{arg} for which no original data is available? Only relevant
for the raw data class \code{tfd}, for which it defaults to \code{FALSE}.
Basis-represented functional data \code{tfb} are always "interpolated".}
}
\value{
\strong{for \code{as.data.frame.tf}:} if \code{unnest} is \code{FALSE} (default), a
one-column \code{data.frame} with a \code{tf}-column containing \code{x}. if \code{unnest} is
\code{TRUE}, a 3-column data frame with columns \code{id} for the (unique) names of
\code{x} or a numeric identifier, \code{arg} and \code{value}, with each row containing
one function evaluation at the original \code{arg}-values.

\strong{for \code{as.matrix.tf}:} a matrix with one row per function and one
column per \code{arg}.

\strong{for \code{as.function.tf}:} an R function with argument \code{arg} that
evaluates \code{x} on \code{arg} and returns the list of function values
}
\description{
Various converters to turn \code{tfb}- or \code{tfd}-vectors into data.frames or
matrices, or even an actual R function.
}
\concept{tidyfun converters}
