% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf.R
\name{tf}
\alias{tf}
\title{Transfer function for input}
\usage{
tf(
  x = NULL,
  delay = 0,
  w0 = 0,
  ar = NULL,
  ma = NULL,
  um = NULL,
  n.back = NULL,
  par.prefix = ""
)
}
\arguments{
\item{x}{input, a ts object or a numeric vector.}

\item{delay}{integer.}

\item{w0}{constant term of the polynomial V(B), double.}

\item{ar}{list of stationary AR polynomials.}

\item{ma}{list of MA polynomials.}

\item{um}{univariate model for stochastic input.}

\item{n.back}{number of backcasts to extend the input.}

\item{par.prefix}{prefix name for parameters.}
}
\value{
An object of the class "tf".
}
\description{
\code{tf} creates a rational transfer function for an input, V(B) = w0(1 -
w_1B - ... - w_qB^q)/(1-d_1B - ... - d_pB^p)B^dX_t. Note that in this
specification the constant term of the MA polynomial is factored out so that
both polynomials in the numerator and denominator are normalized and can be
specified with the \code{lagpol} function in the same way as the operators of
univariate models.
}
\examples{

x <- rep(0, 100)
x[50] <- 1
tfx <- tf(x, w0 = 0.8, ar = "(1 - 0.5B)(1 - 0.7B^12)")

}
\references{
Box, G.E., Jenkins, G.M., Reinsel, G.C. and Ljung, G.M. (2015) Time Series
Analysis: Forecasting and Control. John Wiley & Sons, Hoboken.

Wei, W.W.S. (2006) Time Series Analysis Univariate and Multivariate Methods.
2nd Edition, Addison Wesley, New York, 33-59.
}
\seealso{
\code{\link{um}}.
}
