% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stsm.R
\name{fit2autocov}
\alias{fit2autocov}
\alias{fit2autocov.stsm}
\title{Estimation of a STS model by the method of moments}
\usage{
fit2autocov(mdl, ...)

\method{fit2autocov}{stsm}(mdl, g, method = "BFGS", show.iter = FALSE, ...)
}
\arguments{
\item{mdl}{an object of class \code{stsm}.}

\item{...}{other arguments.}

\item{g}{a vector of theoretical autocovariances (gamma[k], k= 0, ..., K).}

\item{method}{optimation method.}

\item{show.iter}{logical. If TRUE, estimates at each iteration are printed.}
}
\value{
An object of class \code{stsm}.
}
\description{
\code{fit2autocov} fits a STS model to a vector of theoretical
autocovariances.
}
\examples{
um1 <- um(Nile, i = 1, ma = 1)
g <- autocov(um1, lag.max = 1)
# Local level model
b <- 1
C <- as.matrix(1)
stsm1 <- stsm(Nile, b, C, s2v = c(lvl = 0.5), s2u = c(irr = 1), fit = FALSE)
stsm2 <- fit2autocov(stsm1, g)
stsm2
}
