% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfm.R, R/um.R
\name{ucomp.tfm}
\alias{ucomp.tfm}
\alias{ucomp}
\alias{ucomp.um}
\title{Unobserved components}
\usage{
\method{ucomp}{tfm}(
  mdl,
  y = NULL,
  method = c("mixed", "forecast", "backcast"),
  envir = NULL,
  ...
)

ucomp(mdl, ...)

\method{ucomp}{um}(
  mdl,
  z = NULL,
  method = c("mixed", "forecast", "backcast"),
  envir = NULL,
  ...
)
}
\arguments{
\item{mdl}{an object of class \code{\link{um}} or \code{\link{tfm}}.}

\item{y}{an object of class \code{\link{ts}}.}

\item{method}{forward/backward forecasts or a mixture of the two.}

\item{envir}{environment in which the function arguments are evaluated.
If NULL the calling environment of this function will be used.}

\item{...}{additional arguments.}

\item{z}{an object of class \code{\link{ts}}.}
}
\value{
A matrix with the unobserved components.
}
\description{
\code{ucomp} estimates the unobserved components of a time series (trend,
seasonal, cycle, stationary and irregular) from the eventual forecast
function.
}
\examples{
Z <- AirPassengers
um1 <- um(Z, i = list(1, c(1, 12)), ma = list(1, c(1, 12)), bc = TRUE)
uc <- ucomp(um1)
}
