% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf-ctrl-flow-wrappers.R
\name{tf_case}
\alias{tf_case}
\title{tf.case}
\usage{
tf_case(..., pred_fn_pairs = list(...), default = NULL,
  exclusive = FALSE, name = "case")
}
\arguments{
\item{..., pred_fn_pairs}{a list \code{pred_fn_pairs} supplied with the \code{~} like
so: \code{pred ~ fn_body}}

\item{default}{a function, optionally specified with the \code{~}, (or something
coercible to a function via \code{as.function()})}

\item{exclusive}{bool, whether to evaluate all \code{preds} and ensure only one is
true. If \code{FALSE} (the default), then the \code{preds} are evaluated in the order
supplied until the first \code{TRUE} value is encountered (effectively, acting
as an \code{if()... else if() ... else if() ...} chain)}

\item{name}{a string, passed on to \code{tf.case()}}
}
\value{
The result from \code{tf$case()}
}
\description{
This is a minimal wrapper around \code{tf.case()} that allows you to supply the
\code{pred_fn_pairs} using the \code{~}.
}
\examples{
\dontrun{
fizz_buzz_one <- function(x) {
  tf_case(
    x \%\% 15 == 0 ~ "FizzBuzz",
    x \%\%  5 == 0 ~ "Buzz",
    x \%\%  3 == 0 ~ "Fizz",
    default = ~ tf$as_string(x, precision = 0L)
  )
}

fn <- tf_function(autograph(function(n) {
  for(e in tf$range(n))
    tf$print(fizz_buzz_one(e))
}))

x <- tf$constant(16)
fn(x)
}
}
