% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-autograph.R
\name{autograph}
\alias{autograph}
\title{Autograph R code}
\usage{
autograph(x)
}
\arguments{
\item{x}{a function supplied as a bare symbol, or an expression}
}
\value{
if \code{x} is a function, then the the same function with a new parent
environment, \code{package:tfautograph:ag_mask}, which is the autograph mask
that contains implementations of R control flow primitives that are capable
of handling tensorflow tensors. The parent of the
\code{package:tfautograph:ag_mask} in turn is the original environment of \code{x}.

if \code{x} is an expression, then that expression is evaluated in a special
environment with the autograph mask \code{ag_mask} active. If the result of that
expression included local assignment or modifications of variables, (for
example, via \verb{<-}), those modified variables are then exported into the
current frame. The return value of the expression is then returned.
}
\description{
Note, this documentation page is meant to serve as a technical reference, not
an introduction to \code{autograph}. For the latter, please visit the
documentation website: (https://t-kalinowski.github.io/tfautograph/) or see
the package vignettes.
}
