% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataset_methods.R
\name{dataset_prefetch_to_device}
\alias{dataset_prefetch_to_device}
\title{A transformation that prefetches dataset values to the given \code{device}}
\usage{
dataset_prefetch_to_device(dataset, device, buffer_size = NULL)
}
\arguments{
\item{dataset}{A dataset}

\item{device}{A string. The name of a device to which elements will be prefetched
(e.g. "/gpu:0").}

\item{buffer_size}{(Optional.) The number of elements to buffer on device.
Defaults to an automatically chosen value.}
}
\value{
A dataset
}
\description{
A transformation that prefetches dataset values to the given \code{device}
}
\note{
Although the transformation creates a dataset, the transformation must be the
final dataset in the input pipeline.
}
\seealso{
Other dataset methods: 
\code{\link{dataset_batch}()},
\code{\link{dataset_cache}()},
\code{\link{dataset_collect}()},
\code{\link{dataset_concatenate}()},
\code{\link{dataset_decode_delim}()},
\code{\link{dataset_filter}()},
\code{\link{dataset_interleave}()},
\code{\link{dataset_map_and_batch}()},
\code{\link{dataset_map}()},
\code{\link{dataset_padded_batch}()},
\code{\link{dataset_prefetch}()},
\code{\link{dataset_reduce}()},
\code{\link{dataset_repeat}()},
\code{\link{dataset_shuffle_and_repeat}()},
\code{\link{dataset_shuffle}()},
\code{\link{dataset_skip}()},
\code{\link{dataset_take_while}()},
\code{\link{dataset_take}()},
\code{\link{dataset_window}()}
}
\concept{dataset methods}
