% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/feature_columns.R
\name{column_embedding}
\alias{column_embedding}
\title{Construct a Dense Column}
\usage{
column_embedding(categorical_column, dimension, combiner = "mean",
  initializer = NULL, ckpt_to_load_from = NULL,
  tensor_name_in_ckpt = NULL, max_norm = NULL, trainable = TRUE)
}
\arguments{
\item{categorical_column}{A categorical column created by a
\code{column_categorical_*()} function. This column produces the sparse IDs
that are inputs to the embedding lookup.}

\item{dimension}{A positive integer, specifying dimension of the embedding.}

\item{combiner}{A string specifying how to reduce if there are multiple
entries in a single row. Currently \code{"mean"}, \code{"sqrtn"} and \code{"sum"} are
supported, with \code{"mean"} the default. \code{"sqrtn"}' often achieves good
accuracy, in particular with bag-of-words columns. Each of this can be
thought as example level normalizations on the column.}

\item{initializer}{A variable initializer function to be used in embedding
variable initialization. If not specified, defaults to
\code{tf$truncated_normal_initializer} with mean \code{0.0} and standard deviation
\code{1 / sqrt(dimension)}.}

\item{ckpt_to_load_from}{String representing checkpoint name/pattern from
which to restore column weights. Required if \code{tensor_name_in_ckpt} is not
\code{NULL}.}

\item{tensor_name_in_ckpt}{Name of the \code{Tensor} in \code{ckpt_to_load_from} from
which to restore the column weights. Required if \code{ckpt_to_load_from} is not
\code{NULL}.}

\item{max_norm}{If not \code{NULL}, embedding values are l2-normalized to this
value.}

\item{trainable}{Whether or not the embedding is trainable. Default is TRUE.}
}
\value{
A dense column that converts from sparse input.
}
\description{
Use this when your inputs are sparse, but you want to convert them to a dense
representation (e.g., to feed to a DNN). Inputs must be a
categorical column created by any of the \code{column_categorical_*()}
functions.
}
\section{Raises}{

\itemize{
\item ValueError: if \code{dimension} not > 0.
\item ValueError: if exactly one of \code{ckpt_to_load_from} and \code{tensor_name_in_ckpt}
is specified.
\item ValueError: if \code{initializer} is specified and is not callable.
}
}

\seealso{
Other feature column constructors: \code{\link{column_bucketized}},
  \code{\link{column_categorical_weighted}},
  \code{\link{column_categorical_with_hash_bucket}},
  \code{\link{column_categorical_with_identity}},
  \code{\link{column_categorical_with_vocabulary_file}},
  \code{\link{column_categorical_with_vocabulary_list}},
  \code{\link{column_crossed}},
  \code{\link{column_numeric}}, \code{\link{input_layer}}
}
