% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_element.R
\name{element_row_grp_loc}
\alias{element_row_grp_loc}
\title{Element Row Group Location}
\usage{
element_row_grp_loc(
  location = c("indented", "spanning", "column", "noprint", "gtdefault"),
  indent = "  "
)
}
\arguments{
\item{location}{Location of the row group labels. Specifying 'indented'
combines all group and label variables into a single column with each
sub-group indented under its parent. 'spanning' and 'column' retain the
highest level group variable in its own column and combine all remaining
group and label variables into a single column with sub-groups indented. The
highest level group column will either be printed as a spanning header or in
its own column in the gt. The 'noprint' option allows the user to suppress
group values from being printed. Finally, the 'gtdefault' option allows
users to use the {gt} defaults for styling multiple group columns.}

\item{indent}{A string of the number of spaces you want to indent}
}
\value{
element_row_grp_loc object
}
\description{
Element Row Group Location
}
\section{Images}{
 Here are some example outputs:

\if{html}{\out{ <img src="https://raw.githubusercontent.com/GSK-Biostatistics/tfrmt/main/images/tfrmt-row_group_plan-cropped.jpg" alt="Examples showing the difference between the row group locations" style="width:100\%;"> }}
}

\examples{

tfrmt_spec <- tfrmt(
  group = c(grp1, grp2),
  label = label,
  param = param,
  value = value,
  column = column,
  row_grp_plan = row_grp_plan(label_loc = element_row_grp_loc(location = "noprint")),
  body_plan = body_plan(
    frmt_structure(group_val = ".default", label_val = ".default", frmt("xx"))
  )
)

}
\seealso{
\code{\link[=row_grp_plan]{row_grp_plan()}} for more details on how to group row group
structures, \code{\link[=row_grp_structure]{row_grp_structure()}} for more details on how to specify row
group structures, \code{\link[=element_block]{element_block()}} for more details on how to specify
spacing between each group.

\href{https://gsk-biostatistics.github.io/tfrmt/articles/row_grp_plan.html}{Link
to related article}
}
