% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/na_omit.R
\name{na_omit}
\alias{na_omit}
\title{Omit missing values/rows}
\usage{
na_omit(x)
}
\arguments{
\item{x}{Data object}
}
\value{
Data with NA values (if atomic vector), all NA elements (if
  list), or all NA rows (if data frame or matrix) omitted.
}
\description{
Returns data object with NA values (if atomic vector), all NA
elements (if list), or all NA rows (if data frame or matrix)
omitted
}
\examples{

## generate data
df <- data.frame(
  a = I(list(c(1, 2), c(NA_integer_, NA_integer_), c(1, 2))),
  b = c("a", NA_character_, "c"),
  c = c(1.1243, NA_real_, -1.234134)
)

## data frame
na_omit(df)

## matrix
na_omit(as.matrix(df))

## list
na_omit(apply(df, 1, c))

## atomic vector
na_omit(df$b)

}
