% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_test.R
\name{stat_test}
\alias{stat_test}
\title{Calculate p-values for feature sets or features relative to an empirical null or each other using resampled t-tests}
\usage{
stat_test(
  data,
  iter_data,
  row_id,
  by_set = FALSE,
  hypothesis,
  metric,
  train_test_sizes,
  n_resamples
)
}
\arguments{
\item{data}{\code{data.frame} of raw classification accuracy results}

\item{iter_data}{\code{data.frame} containing the values to iterate over for seed and either feature name or set name}

\item{row_id}{\code{integer} denoting the row ID for \code{iter_data} to filter to}

\item{by_set}{\code{Boolean} specifying whether you want to compare feature sets (if \code{TRUE}) or individual features (if \code{FALSE}).}

\item{hypothesis}{\code{character} denoting whether p-values should be calculated for each feature set or feature (depending on \code{by_set} argument) individually relative to the null if \code{use_null = TRUE} in \code{tsfeature_classifier} through \code{"null"}, or whether pairwise comparisons between each set or feature should be conducted on main model fits only through \code{"pairwise"}.}

\item{metric}{\code{character} denoting the classification performance metric to use in statistical testing. Can be one of \code{"accuracy"}, \code{"precision"}, \code{"recall"}, \code{"f1"}. Defaults to \code{"accuracy"}}

\item{train_test_sizes}{\code{integer} vector containing the train and test set sample sizes}

\item{n_resamples}{\code{integer} denoting the number of resamples that were calculated}
}
\value{
object of class \code{data.frame}
}
\description{
Calculate p-values for feature sets or features relative to an empirical null or each other using resampled t-tests
}
\author{
Trent Henderson
}
