% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resume_hmc.R
\name{resume}
\alias{resume}
\alias{resume.effects}
\title{Resume HMC using a previous fit}
\usage{
resume(object, ...)

\method{resume}{effects}(
  object,
  init_type = c("last", "orig"),
  inits,
  iters,
  warmup = iters/2,
  chains = 1,
  cores = 1,
  seed = object$seeds$next_seed,
  return_summary = TRUE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{object}{(required) Ouput of \code{\link{est.functions}}.}

\item{...}{Additional arguments for methods.}

\item{init_type}{Type of initial parameters, either the original set that was
passed to \code{\link{est.functions}} or the last parameter sample from the
reused fit. Defaults to last.}

\item{inits}{List of values for parameter initialization. Overrides init_type.}

\item{iters}{Number of iterations for for fitting. Defaults to 300 and 100 for
HMC and ML, respectively.}

\item{warmup}{For HMC, proportion of iterations devoted to warmup. Defaults to
iters/2.}

\item{chains}{For HMC, number of parallel chains. Defaults to 1.}

\item{cores}{For HMC, number of cores to parallelize chains. Defaults to 1.}

\item{seed}{Seed for the random number generator to reproduce previous
results.}

\item{return_summary}{Logical flag to return results summary. Defaults to TRUE.}

\item{verbose}{Logical flag to print progress information. Defaults to FALSE.}
}
\value{
An object of class effects containing
\describe{
\item{model}{List containing the parameters, fit, and summary.}
\item{gene_table}{Dataframe containing the formatted predicted gene information
from \code{\link{predict.topics}}.}
}
}
\description{
Perform HMC using a previously compiled Stan model. This is specifically useful in
cases when a previous fit failed to converged (i.e., Rhat > 1.1 for a portion
of parameter estimates), thus requiring more iterations.
}
\examples{
formula <- ~DIAGNOSIS
refs <- 'Not IBD'

dat <- prepare_data(otu_table=GEVERS$OTU,rows_are_taxa=FALSE,tax_table=GEVERS$TAX,
                    metadata=GEVERS$META,formula=formula,refs=refs,
                    cn_normalize=TRUE,drop=TRUE)

\dontrun{
topics <- find_topics(dat,K=15)

functions <- predict(topics,reference_path='/references/ko_13_5_precalculated.tab.gz')

function_effects_init <- est(functions,level=3,iters=150,
                             prior=c('laplace','t','laplace'))
function_effects <- resume(function_effects_init,init_type='last',
                           iters=300,chains=4)
}

}
\references{
Stan Development Team. 2016. RStan: the R interface to Stan.
http://mc-stan.org
}
\seealso{
\code{\link[rstan]{stan}} \code{\link{est.functions}}
}
