% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_palette_voxel.R
\name{voxel_colormap}
\alias{voxel_colormap}
\alias{create_colormap}
\alias{save_colormap}
\alias{freeserfer_colormap}
\alias{load_colormap}
\title{Color maps for volume or surface data}
\usage{
create_colormap(
  gtype = c("surface", "volume"),
  dtype = c("continuous", "discrete"),
  key,
  color,
  value,
  alpha = FALSE,
  con = NULL,
  ...
)

save_colormap(cmap, con)

freeserfer_colormap(con)

load_colormap(con)
}
\arguments{
\item{gtype}{geometry type, choices are \code{"surface"}, \code{"volume"}}

\item{dtype}{data type, \code{"continuous"} or \code{"discrete"}}

\item{key}{non-negative integer vector corresponding to color values;
its length must exceed 1; see 'Details'}

\item{color}{characters, corresponding to color strings for each key}

\item{value}{actual value for each key}

\item{alpha}{whether to respect transparency}

\item{con}{a file path to write results to or to read from. The
file path can be passed as \code{voxel_colormap} into \code{\link{threejs_brain}}.}

\item{...}{used by continuous color maps, passed to
\code{\link[grDevices]{colorRampPalette}}}

\item{cmap}{color map object}
}
\value{
A list of color map information
}
\description{
Color maps for volume or surface data
}
\details{
Internal 'JavaScript' shader implementation uses integer color \code{key}s to
connect color palettes and corresponding values. The keys must be
non-negative.

Zero key is a special color key reserved by system. Please avoid using it
for valid values.
}
\examples{

# Creates a symmetric continuous colormap with 3 keys
# The color range is -10 to 10
# The colors are 'blue','white','red' for these keys

pal <- create_colormap(
  gtype = "volume", dtype = "continuous",
  key = c(1,2,3), value = c(-10,0,10),
  color = c('blue','white','red'))

print( pal )

# ---------------- Get colormap key from a value ------------

# returns key index starting from
pal$get_key( -10 )

# nearest value
pal$get_key( 2 )

# set threshold, key is now 0 (no color)
pal$get_key( 2, max_delta = 1 )


# ---------------- Save and load ----------------
f <- tempfile( fileext = '.json' )
save_colormap( pal, f )
cat(readLines(f), sep = '\n')

load_colormap(f)

}
