% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frame-data.R
\name{frame_data}
\alias{frame_data}
\title{Row-wise tibble creation}
\usage{
frame_data(...)
}
\arguments{
\item{...}{Arguments specifying the structure of a \code{tibble}.
Variable names should be formulas, and may only appear before the data.}
}
\value{
A \code{\link{tibble}}.
}
\description{
Create \code{\link{tibble}}s laying out the data in rows, rather than
in columns. This is useful for small tables of data where readability is
important.  Please see \link{tibble-package} for a general introduction.
}
\examples{
frame_data(
  ~colA, ~colB,
  "a",   1,
  "b",   2,
  "c",   3
)

# frame_data will create a list column if the value in each cell is
# not a scalar
frame_data(
  ~x,  ~y,
  "a", 1:3,
  "b", 4:6
)
}

