% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rownames.R
\name{rownames}
\alias{column_to_rownames}
\alias{has_rownames}
\alias{remove_rownames}
\alias{rownames}
\alias{rownames_to_column}
\title{Tools for working with row names}
\usage{
has_rownames(df)

remove_rownames(df)

rownames_to_column(df, var = "rowname")

column_to_rownames(df, var = "rowname")
}
\arguments{
\item{df}{A data frame}

\item{var}{Name of column to use for rownames.}
}
\description{
While a tibble can have row names (e.g., when converting from a regular data
frame), they are removed when subsetting with the \code{[} operator.
A warning will be raised when attempting to assign non-\code{NULL} row names
to a tibble.
Generally, it is best to avoid row names, because they are basically a
character column with different semantics to every other column. These
functions allow to you detect if a data frame has row names
(\code{has_rownames}), remove them (\code{remove_rownames}), or convert
them back-and-forth between an explicit column (\code{rownames_to_column}
and \code{column_to_rownames}).
}
\details{
In the printed output, the presence of row names is indicated by a star just
above the row numbers.
}
\examples{
has_rownames(mtcars)
has_rownames(iris)
has_rownames(remove_rownames(mtcars))

head(rownames_to_column(mtcars))

mtcars_tbl <- as_tibble(rownames_to_column(mtcars))
mtcars_tbl
column_to_rownames(as.data.frame(mtcars_tbl))
}

