% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/new.R
\name{new_tibble}
\alias{new_tibble}
\alias{validate_tibble}
\title{Tibble constructor and validator}
\usage{
new_tibble(x, ..., nrow, class = NULL, subclass = NULL)

validate_tibble(x)
}
\arguments{
\item{x}{A tibble-like object.}

\item{...}{Name-value pairs of additional attributes.}

\item{nrow}{The number of rows, required.}

\item{class}{Subclasses to assign to the new object, default: none.}

\item{subclass}{Deprecated, retained for compatibility. Please use the \code{class} argument.}
}
\description{
Creates or validates a subclass of a tibble.
These function is mostly useful for package authors that implement subclasses
of a tibble, like \pkg{sf} or \pkg{tsibble}.

\code{new_tibble()} creates a new object as a subclass of \code{tbl_df}, \code{tbl} and \code{data.frame}.
This function is optimized for performance, checks are reduced to a minimum.

\code{validate_tibble()} checks a tibble for internal consistency.
Correct behavior can be guaranteed only if this function
runs without raising an error.
}
\section{Construction}{


For \code{new_tibble()}, \code{x} must be a list.
The \code{...} argument allows adding more attributes to the subclass.
An \code{nrow} argument is required.
This should be an integer of length 1,
and every element of the list \code{x} should have \code{\link[vctrs:vec_size]{vctrs::vec_size()}}
equal to this value.
(But this is not checked by the constructor).
This takes the place of the "row.names" attribute in a data frame.
\code{x} must have names (or be empty),
but the names are not checked for correctness.
}

\section{Validation}{

\code{validate_tibble()} checks for "minimal" names
and that all columns are vectors, data frames or matrices.
It also makes sure that all columns have the same length,
and that \code{\link[vctrs:vec_size]{vctrs::vec_size()}} is consistent with the data.
}

\examples{
# The nrow argument is always required:
new_tibble(list(a = 1:3, b = 4:6), nrow = 3)

# Existing row.names attributes are ignored:
try(new_tibble(iris, nrow = 3))

# The length of all columns must be compatible with the nrow argument:
try(new_tibble(list(a = 1:3, b = 4:6), nrow = 2))
}
\seealso{
\code{\link[=tibble]{tibble()}} and \code{\link[=as_tibble]{as_tibble()}} for ways to construct a tibble
with recycling of scalars and automatic name repair.
}
