% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tic_analyse.R
\name{tic_analyse}
\alias{tic_analyse}
\title{Plot and analyse time-intensity data}
\usage{
tic_analyse(
  data,
  timevar,
  intensityvar,
  loess.span = 0.1,
  AUCmax = NULL,
  peakproportion = NULL,
  plotresult = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe with time and intensity values as columns.}

\item{timevar}{A character string (in quotes) with the dataframe column name for the time variable.}

\item{intensityvar}{A character string (in quotes) with dataframe column name for the intensity variable.}

\item{loess.span}{A number between 0 and 1, with larger values resulting in a smoother curve.}

\item{AUCmax}{A number - the maximum time that area under the curve is measured until.}

\item{peakproportion}{A number between 0 and 1 which is used in the time to peak proportion calculations.}

\item{plotresult}{TRUE or FALSE to determine whether a plot of the results is generated.}

\item{...}{Additional arguments to be passed into the loess() function.}
}
\value{
A dataframe with the results. Depending on the plotresult argument can also
return a plot of the smoothed curve.
}
\description{
This function plots and analyzes time-intensity data, such as data from (contrast-enhanced)
ultrasound cineloops. Peak intensity and time to peak intensity are calculated from a smoothed
curve through the data (loess smoother). Area under the curve is calculated from the raw data
using the trapezium method for integration. Time to peak proportion (for example time to
90 percent of peak) can also be calculated.
}
\details{
A plot of the data is generated and a dataframe with the results is returned.
}
\examples{

# Example usage:

# Generating simulated data
set.seed(123)
example_data <- data.frame(time = seq(0, 82, by = 0.25))
random_vals <- sample(1:10, nrow(example_data), replace = TRUE)
example_data$regionA_intensity <- log(example_data$time + 1) * 50 -
  example_data$time * 2 + random_vals
example_data$regionB_intensity <- log(example_data$time + 7, base = 10) *
  80 - example_data$time * 1.5 + random_vals

# Example with defaults:

tic_analyse(data = example_data, timevar = "time", intensityvar = "regionA_intensity")

# Example with additional arguments:

tic_analyse(data = example_data, timevar = "time", intensityvar = "regionA_intensity",
                  loess.span = 0.1, AUCmax = 30, peakproportion = 0.9, plotresult = TRUE)


}
