% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core.R
\name{get_country_by_calling_code}
\alias{get_country_by_calling_code}
\title{get_country_by_calling_code}
\usage{
get_country_by_calling_code(call_code)
}
\arguments{
\item{call_code}{A character string representing the calling code, root calling code, or suffix. The input is case-insensitive.}
}
\value{
A data frame containing the list of countries that match the provided calling code.
The columns include country codes (CCA2 and CCA3), common name, official name, capital, region, subregion, continents,
currencies, calling code details (root, suffixes, and full calling code), and geographic coordinates (latitude and longitude).
}
\description{
This function retrieves information about countries based on a specified calling code or part of it.
The input can be a root calling code, suffix, or a full calling code, and the function is case-insensitive.
}
\note{
The function relies on the pre-loaded \code{restcountries_data} dataset. Ensure that this dataset is loaded before invoking the function.
The function searches across the root calling code, suffixes, and full calling code using case-insensitive matching.
}
\examples{
\donttest{
# Example usage: Find country information by root calling code
us_info <- get_country_by_calling_code("+1")
print(us_info)

# Example usage: Find country information by calling code suffix
uk_info <- get_country_by_calling_code("44")
print(uk_info)

# Example usage: Find country information by full calling code
india_info <- get_country_by_calling_code("+91")
print(india_info)
}
}
