% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_data_factors.R
\name{download_data_factors_ff}
\alias{download_data_factors_ff}
\title{Download and Process Fama-French Factor Data}
\usage{
download_data_factors_ff(type, start_date = NULL, end_date = NULL)
}
\arguments{
\item{type}{The type of dataset to download, corresponding to the specific
Fama-French model and frequency.}

\item{start_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the start date for the data. If not provided, the full dataset is returned.}

\item{end_date}{Optional. A character string or Date object in "YYYY-MM-DD" format
specifying the end date for the data. If not provided, the full dataset is returned.}
}
\value{
A tibble with processed factor data, including the date, risk-free
rate, market excess return, and other factors, filtered by the specified
date range.
}
\description{
Downloads and processes Fama-French factor data based on the specified type
(e.g., "factors_ff_3_monthly"), and date range. The function first checks if
the specified type is supported and requires the 'frenchdata' package to
download the data. It processes the raw data into a structured format,
including date conversion, scaling factor values, and filtering by the
specified date range.
}
\details{
If there are multiple tables in the raw Fama-French data (e.g., value-weighted
and equal-weighted returns), then the function only returns the first table
because these are the most popular. Please use the \code{frenchdata} package
directly if you need less commonly used tables.
}
\examples{
\donttest{
  download_data_factors_ff("factors_ff_3_monthly", "2000-01-01", "2020-12-31")
  download_data_factors_ff("factors_ff_10_industry_portfolios_monthly", "2000-01-01", "2020-12-31")
}
}
